/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.name.IHasName;
import com.helger.xml.EXMLParserPropertyType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public enum EXMLParserProperty implements IHasName
{
    GENERAL_XML_STRING(EXMLParserPropertyType.GENERAL, "http://xml.org/sax/properties/xml-string", String.class),
    GENERAL_EXTERNAL_SCHEMALOCATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/schema/external-schemaLocation", String.class),
    GENERAL_EXTERNAL_NONAMESPACE_SCHEMALOCATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", String.class),
    GENERAL_ROOT_ELEMENT_DECLARATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/validation/schema/root-element-declaration", QName.class),
    GENERAL_ROOT_TYPE_DECLARATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/validation/schema/root-type-definition", QName.class),
    GENERAL_INPUT_BUFFER_SIZE(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/input-buffer-size", Integer.class),
    GENERAL_LOCALE(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/locale", Locale.class),
    GENERAL_SECURITY_MANAGER(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/security-manager", "org.apache.xerces.util.SecurityManager"),
    DOM_CURRENT_ELEMENT_NODE(EXMLParserPropertyType.DOM, "http://apache.org/xml/properties/dom/current-element-node", Element.class),
    DOM_DOCUMENT_CLASS_NAME(EXMLParserPropertyType.DOM, "http://apache.org/xml/properties/dom/document-class-name", String.class),
    SAX_DECLARATION_HANDLER(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/declaration-handler", DeclHandler.class),
    SAX_LEXICAL_HANDLER(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/lexical-handler", LexicalHandler.class),
    SAX_DOM_NODE(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/dom-node", Node.class),
    SAX_XML_VERSION(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/document-xml-version", String.class),
    JAXP_SCHEMA_LANGUAGE(EXMLParserPropertyType.GENERAL, "http://java.sun.com/xml/jaxp/properties/schemaLanguage", String.class),
    JAXP_SCHEMA_SORUCE(EXMLParserPropertyType.GENERAL, "http://java.sun.com/xml/jaxp/properties/schemaSource", Object.class);

    private static final Logger LOGGER;
    private final EXMLParserPropertyType m_ePropertyType;
    private final String m_sName;
    private Class<?> m_aValueClass;
    @CodingStyleguideUnaware
    private boolean m_bWarnedOnceXMLReader = false;
    private boolean m_bWarnedOnceSchemaFactory = false;
    private boolean m_bWarnedOnceValidator = false;
    private final String m_sValueClassName;

    private EXMLParserProperty(@Nonnull @Nonempty EXMLParserPropertyType eXMLParserPropertyType, String string2, String string3) {
        this.m_ePropertyType = eXMLParserPropertyType;
        this.m_sName = string2;
        this.m_aValueClass = GenericReflection.getClassFromNameSafe(string3);
        this.m_sValueClassName = string3;
    }

    private EXMLParserProperty(@Nonnull EXMLParserPropertyType eXMLParserPropertyType, String string2, Class<?> clazz) {
        this.m_ePropertyType = eXMLParserPropertyType;
        this.m_sName = string2;
        this.m_aValueClass = clazz;
        this.m_sValueClassName = clazz.getName();
    }

    @Nonnull
    public EXMLParserPropertyType getPropertyType() {
        return this.m_ePropertyType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nullable
    public Class<?> getValueClass() {
        return this.m_aValueClass;
    }

    @Nonnull
    @Nonempty
    public String getValueClassName() {
        return this.m_sValueClassName;
    }

    @Nonnull
    private Object _getFixedValue(@Nonnull Object object) {
        if (this == GENERAL_LOCALE && object instanceof Locale) {
            Locale locale = (Locale)object;
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return Locale.ROOT;
            }
        }
        return object;
    }

    public void applyTo(@Nonnull XMLReader xMLReader, Object object) {
        block6: {
            ValueEnforcer.notNull(xMLReader, "Parser");
            if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && this.m_ePropertyType != EXMLParserPropertyType.SAX && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Parser property '" + this.name() + "' is not applicable for SAX parsers!");
            }
            try {
                Object object2 = this._getFixedValue(object);
                xMLReader.setProperty(this.m_sName, object2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (!this.m_bWarnedOnceXMLReader) {
                    LOGGER.warn("XML Parser does not recognize property '" + this.name() + "'");
                    if (LOGGER.isWarnEnabled()) {
                        this.m_bWarnedOnceXMLReader = true;
                    }
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn("XML Parser does not support property '" + this.name() + "'");
            }
        }
    }

    public void applyTo(@Nonnull DocumentBuilderFactory documentBuilderFactory, Object object) {
        block3: {
            ValueEnforcer.notNull(documentBuilderFactory, "DocumentBuilderFactory");
            if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && this.m_ePropertyType != EXMLParserPropertyType.DOM && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Parser property '" + this.name() + "' is not applicable for DOM parsers!");
            }
            try {
                Object object2 = this._getFixedValue(object);
                documentBuilderFactory.setAttribute(this.m_sName, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("DOM parser does not support property '" + this.name() + "'");
            }
        }
    }

    public void applyTo(@Nonnull SchemaFactory schemaFactory, Object object) {
        block6: {
            ValueEnforcer.notNull(schemaFactory, "SchemaFactory");
            if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Parser property '" + this.name() + "' is not applicable for SchemaFactory!");
            }
            try {
                Object object2 = this._getFixedValue(object);
                schemaFactory.setProperty(this.m_sName, object2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (!this.m_bWarnedOnceSchemaFactory) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("SchemaFactory does not recognize property '" + this.name() + "'");
                    }
                    this.m_bWarnedOnceSchemaFactory = true;
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn("SchemaFactory does not support property '" + this.name() + "'");
            }
        }
    }

    public void applyTo(@Nonnull Validator validator, Object object) {
        block6: {
            ValueEnforcer.notNull(validator, "Validator");
            if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Parser property '" + this.name() + "' is not applicable for Validator!");
            }
            try {
                Object object2 = this._getFixedValue(object);
                validator.setProperty(this.m_sName, object2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (!this.m_bWarnedOnceValidator) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Validator does not recognize property '" + this.name() + "'");
                    }
                    this.m_bWarnedOnceValidator = true;
                }
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn("Validator does not support property '" + this.name() + "'");
            }
        }
    }

    @Nullable
    public static EXMLParserProperty getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EXMLParserProperty.class, string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<EXMLParserProperty> getAllPropertiesOfType(@Nonnull EXMLParserPropertyType eXMLParserPropertyType) {
        ValueEnforcer.notNull(eXMLParserPropertyType, "PropertyType");
        return CommonsArrayList.createFiltered(EXMLParserProperty.values(), eXMLParserProperty -> eXMLParserProperty.getPropertyType() == eXMLParserPropertyType);
    }

    static {
        LOGGER = LoggerFactory.getLogger(EXMLParserProperty.class);
    }
}

