/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.regex.RegExCache;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CXMLRegEx {
    private static final String BASECHAR = "(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))";
    private static final String IDEOGRAPHIC = "(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))";
    private static final String DIGIT = "(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))";
    private static final String EXTENDER = "(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be]))";
    private static final String COMBININGCHAR = "(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))";
    private static final String LETTER = "(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))";
    private static final String NAMECHAR = "(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))";
    private static final String NAME = "(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)";
    private static final String NMTOKEN = "(?:(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))+)";
    private static final String ENTITYREF = "(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)";
    private static final String CHARREF = "(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);)";
    private static final String REFERENCE = "(?:(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)|(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);))";
    private static final String ATTVALUE = "(?:\"(?:[^\\&<]*|(?:(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)|(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);)))\"|'(?:[^'&<]|(?:(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)|(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);)))*')";
    private static final String NCNAMECHAR = "(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))";
    private static final String NCNAME = "(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)";
    private static final String PREFIX = "(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)";
    private static final String LOCALPATZ = "(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)";
    private static final String QNAME = "(?:(?:(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*):)?(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*))";
    public static final Pattern PATTERN_ATTVALUE = RegExCache.getPattern("(?:\"(?:[^\\&<]*|(?:(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)|(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);)))\"|'(?:[^'&<]|(?:(?:\\&(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*);)|(?:\\&#(?:[0-9]+|x[0-9a-fA-F]+);)))*')");
    public static final Pattern PATTERN_NAME = RegExCache.getPattern("(?:(?:[:_]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)");
    public static final Pattern PATTERN_NAME_QUICK = RegExCache.getPattern("[a-zA-Z_][a-zA-Z0-9]*");
    public static final Pattern PATTERN_NCNAME = RegExCache.getPattern("(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*)");
    public static final Pattern PATTERN_NMTOKEN = RegExCache.getPattern("(?:(?:[-._:]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))+)");
    public static final Pattern PATTERN_QNAME = RegExCache.getPattern("(?:(?:(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*):)?(?:(?:_|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5]))))(?:[-._]|(?:(?:[a-zA-Z]|\u00c3[\u0080-\u0096\u0098-\u00b6\u00b8-\u00bf]|\u00c4[\u0080-\u00b1\u00b4-\u00be]|\u00c5[\u0081-\u0088\u008a-\u00be]|\u00c6[\u0080-\u00bf]|\u00c7[\u0080-\u0083\u008d-\u00b0\u00b4\u00b5\u00ba-\u00bf]|\u00c8[\u0080-\u0097]|\u00c9[\u0090-\u00bf]|\u00ca[\u0080-\u00a8\u00bb-\u00bf]|\u00cb[\u0080\u0081]|\u00ce[\u0086\u0088-\u008a\u008c\u008e-\u00a1\u00a3-\u00bf]|\u00cf[\u0080-\u008e\u0090-\u0096\u009a\u009c\u009e\u00a0\u00a2-\u00b3]|\u00d0[\u0081-\u008c\u008e-\u00bf]|\u00d1[\u0080-\u008f\u0091-\u009c\u009e-\u00bf]|\u00d2[\u0080\u0081\u0090-\u00bf]|\u00d3[\u0080-\u0084\u0087\u0088\u008b\u008c\u0090-\u00ab\u00ae-\u00b5\u00b8\u00b9]|\u00d4[\u00b1-\u00bf]|\u00d5[\u0080-\u0096\u0099\u00a1-\u00bf]|\u00d6[\u0080-\u0086]|\u00d7[\u0090-\u00aa\u00b0-\u00b2]|\u00d8[\u00a1-\u00ba]|\u00d9[\u0081-\u008a\u00b1-\u00bf]|\u00da[\u0080-\u00b7\u00ba-\u00be]|\u00db[\u0080-\u008e\u0090-\u0093\u0095\u00a5\u00a6]|\u00e0(?:\u00a4[\u0085-\u00b9\u00bd]|\u00a5[\u0098-\u00a1]|\u00a6[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b6-\u00b9]|\u00a7[\u009c\u009d\u009f-\u00a1\u00b0\u00b1]|\u00a8[\u0085-\u008a\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5\u00b6\u00b8\u00b9]|\u00a9[\u0099-\u009c\u009e\u00b2-\u00b4]|\u00aa[\u0085-\u008b\u008d\u008f-\u0091\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b5-\u00b9\u00bd]|\u00ab\u00a0|\u00ac[\u0085-\u008c\u008f\u0090\u0093-\u00a8\u00aa-\u00b0\u00b2\u00b3\u00b6-\u00b9\u00bd]|\u00ad[\u009c\u009d\u009f-\u00a1]|\u00ae[\u0085-\u008a\u008e-\u0090\u0092-\u0095\u0099\u009a\u009c\u009e\u009f\u00a3\u00a4\u00a8-\u00aa\u00ae-\u00b5\u00b7-\u00b9]|\u00b0[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b1[\u00a0\u00a1]|\u00b2[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b3\u00b5-\u00b9]|\u00b3[\u009e\u00a0\u00a1]|\u00b4[\u0085-\u008c\u008e-\u0090\u0092-\u00a8\u00aa-\u00b9]|\u00b5[\u00a0\u00a1]|\u00b8[\u0081-\u00ae\u00b0\u00b2\u00b3]|\u00b9[\u0080-\u0085]|\u00ba[\u0081\u0082\u0084\u0087\u0088\u008a\u008d\u0094-\u0097\u0099-\u009f\u00a1-\u00a3\u00a5\u00a7\u00aa\u00ab\u00ad\u00ae\u00b0\u00b2\u00b3\u00bd]|\u00bb[\u0080-\u0084]|\u00bd[\u0080-\u0087\u0089-\u00a9])|\u00e1(?:\u0082[\u00a0-\u00bf]|\u0083[\u0080-\u0085\u0090-\u00b6]|\u0084[\u0080\u0082\u0083\u0085-\u0087\u0089\u008b\u008c\u008e-\u0092\u00bc\u00be]|\u0085[\u0080\u008c\u008e\u0090\u0094\u0095\u0099\u009f-\u00a1\u00a3\u00a5\u00a7\u00a9\u00ad\u00ae\u00b2\u00b3\u00b5]|\u0086[\u009e\u00a8\u00ab\u00ae\u00af\u00b7\u00b8\u00ba\u00bc-\u00bf]|\u0087[\u0080-\u0082\u00ab\u00b0\u00b9]|[\u00b8\u00b9][\u0080-\u00bf]|\u00ba[\u0080-\u009b\u00a0-\u00bf]|\u00bb[\u0080-\u00b9]|\u00bc[\u0080-\u0095\u0098-\u009d\u00a0-\u00bf]|\u00bd[\u0080-\u0085\u0088-\u008d\u0090-\u0097\u0099\u009b\u009d\u009f-\u00bd]|\u00be[\u0080-\u00b4\u00b6-\u00bc\u00be]|\u00bf[\u0082-\u0084\u0086-\u008c\u0090-\u0093\u0096-\u009b\u00a0-\u00ac\u00b2-\u00b4\u00b6-\u00bc])|\u00e2(?:\u0084[\u00a6\u00aa\u00ab\u00ae]|\u0086[\u0080-\u0082])|\u00e3(?:\u0081[\u0081-\u00bf]|\u0082[\u0080-\u0094\u00a1-\u00bf]|\u0083[\u0080-\u00ba]|\u0084[\u0085-\u00ac])|\u00ea(?:[\u00b0-\u00bf][\u0080-\u00bf])|\u00eb(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ec(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00ed(?:[\u0080-\u009d][\u0080-\u00bf]|\u009e[\u0080-\u00a3]))|(?:\u00e3\u0080[\u0087\u00a1-\u00a9]|\u00e4(?:[\u00b8-\u00bf][\u0080-\u00bf])|\u00e5(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e6(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e7(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e8(?:[\u0080-\u00bf][\u0080-\u00bf])|\u00e9(?:[\u0080-\u00bd][\u0080-\u00bf]|\u00be[\u0080-\u00a5])))|(?:[0-9]|\u00d9[\u00a0-\u00a9]|\u00db[\u00b0-\u00b9]|\u00e0(?:\u00a5[\u00a6-\u00af]|\u00a7[\u00a6-\u00af]|\u00a9[\u00a6-\u00af]|\u00ab[\u00a6-\u00af]|\u00ad[\u00a6-\u00af]|\u00af[\u00a7-\u00af]|\u00b1[\u00a6-\u00af]|\u00b3[\u00a6-\u00af]|\u00b5[\u00a6-\u00af]|\u00b9[\u0090-\u0099]|\u00bb[\u0090-\u0099]|\u00bc[\u00a0-\u00a9]))|(?:\u00cc[\u0080-\u00bf]|\u00cd[\u0080-\u0085\u00a0\u00a1]|\u00d2[\u0083-\u0086]|\u00d6[\u0091-\u00a1\u00a3-\u00b9\u00bb-\u00bd\u00bf]|\u00d7[\u0081\u0082\u0084]|\u00d9[\u008b-\u0092\u00b0]|\u00db[\u0096-\u00a4\u00a7\u00a8\u00aa-\u00ad]|\u00e0(?:\u00a4[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a5[\u0080-\u008d\u0091-\u0094\u00a2\u00a3]|\u00a6[\u0081-\u0083\u00bc\u00be\u00bf]|\u00a7[\u0080-\u0084\u0087\u0088\u008b-\u008d\u0097\u00a2\u00a3]|\u00a8[\u0082\u00bc\u00be\u00bf]|\u00a9[\u0080-\u0082\u0087\u0088\u008b-\u008d\u00b0\u00b1]|\u00aa[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ab[\u0080-\u0085\u0087-\u0089\u008b-\u008d]|\u00ac[\u0081-\u0083\u00bc\u00be\u00bf]|\u00ad[\u0080-\u0083\u0087\u0088\u008b-\u008d\u0096\u0097]|\u00ae[\u0082\u0083\u00be\u00bf]|\u00af[\u0080-\u0082\u0086-\u0088\u008a-\u008d\u0097]|\u00b0[\u0081-\u0083\u00be\u00bf]|\u00b1[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b2[\u0082\u0083\u00be\u00bf]|\u00b3[\u0080-\u0084\u0086-\u0088\u008a-\u008d\u0095\u0096]|\u00b4[\u0082\u0083\u00be\u00bf]|\u00b5[\u0080-\u0083\u0086-\u0088\u008a-\u008d\u0097]|\u00b8[\u00b1\u00b4-\u00ba]|\u00b9[\u0087-\u008e]|\u00ba[\u00b1\u00b4-\u00b9\u00bb\u00bc]|\u00bb[\u0088-\u008d]|\u00bc[\u0098\u0099\u00b5\u00b7\u00b9\u00be\u00bf]|\u00bd[\u00b1-\u00bf]|\u00be[\u0080-\u0084\u0086-\u008b\u0090-\u0095\u0097\u0099-\u00ad\u00b1-\u00b7\u00b9])|\u00e2\u0083[\u0090-\u009c\u00a1]|\u00e3(?:\u0080[\u00aa-\u00af]|\u0082[\u0099\u009a]))|(?:\u00c2\u00b7|\u00cb[\u0090\u0091]|\u00ce\u0087|\u00d9\u0080|\u00e0(?:\u00b9\u0086|\u00bb\u0086)|\u00e3(?:\u0080[\u0085\u00b1-\u00b5]|\u0082[\u009d\u009e]|\u0083[\u00bc-\u00be])))*))");
    private static final CXMLRegEx s_aInstance = new CXMLRegEx();

    private CXMLRegEx() {
    }
}

