/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.util;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.GenericReflection;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.util.RequestFieldDataMultiValue;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SessionBackedRequestFieldDataMultiValue
extends RequestFieldDataMultiValue {
    public SessionBackedRequestFieldDataMultiValue(@Nonnull String string) {
        super(string);
        this._init();
    }

    public SessionBackedRequestFieldDataMultiValue(@Nonnull String string, @Nullable Collection<String> collection) {
        super(string, collection);
        this._init();
    }

    @Nonnull
    @Nonempty
    public String getSessionFieldName() {
        return "$ph-requestfield.multi." + this.getFieldName();
    }

    private void _init() {
        ICommonsList<String> iCommonsList = super.getRequestValuesWithoutDefault();
        if (iCommonsList != null) {
            WebScopeManager.getSessionScope(true).attrs().putIn(this.getSessionFieldName(), iCommonsList);
        }
    }

    @Override
    public ICommonsList<String> getDefaultValues() {
        Object v;
        ICommonsList<String> iCommonsList = super.getDefaultValues();
        ISessionWebScope iSessionWebScope = WebScopeManager.getSessionScope(false);
        if (iSessionWebScope != null && (v = iSessionWebScope.attrs().get(this.getSessionFieldName())) != null) {
            return (ICommonsList)GenericReflection.uncheckedCast(v);
        }
        return iCommonsList;
    }
}

