/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.request;

import com.helger.commons.ValueEnforcer;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.multipart.RequestWebScopeMultipart;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class RequestScopeInitializer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestScopeInitializer.class);
    private final IRequestWebScope m_aRequestScope;
    private boolean m_bCreatedIt;

    private RequestScopeInitializer(@Nonnull IRequestWebScope iRequestWebScope, boolean bl) {
        this.m_aRequestScope = ValueEnforcer.notNull(iRequestWebScope, "RequestScope");
        this.m_bCreatedIt = bl;
    }

    @Nonnull
    public IRequestWebScope getRequestScope() {
        return this.m_aRequestScope;
    }

    public boolean isNew() {
        return this.m_bCreatedIt;
    }

    public void internalSetDontDestroyRequestScope() {
        this.m_bCreatedIt = false;
    }

    @Override
    public void close() {
        if (this.m_bCreatedIt) {
            WebScopeManager.onRequestEnd();
        }
    }

    @Nonnull
    public static RequestScopeInitializer createMultipart(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        return RequestScopeInitializer.create(httpServletRequest, httpServletResponse, RequestWebScopeMultipart::new);
    }

    @Nonnull
    public static RequestScopeInitializer create(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull BiFunction<? super HttpServletRequest, ? super HttpServletResponse, IRequestWebScope> biFunction) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScopeOrNull();
        if (iRequestWebScope != null) {
            if (iRequestWebScope.isValid()) {
                return new RequestScopeInitializer(iRequestWebScope, false);
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The existing request scope is no longer valid - creating a new one: " + iRequestWebScope.toString());
            }
        }
        IRequestWebScope iRequestWebScope2 = WebScopeManager.onRequestBegin(httpServletRequest, httpServletResponse, biFunction);
        return new RequestScopeInitializer(iRequestWebScope2, true);
    }
}

