/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.impl;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.scope.SessionScope;
import com.helger.web.scope.ISessionWebScope;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionWebScope
extends SessionScope
implements ISessionWebScope {
    private static final long serialVersionUID = 8912368923565761267L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionWebScope.class);
    private final LocalDateTime m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
    private final transient HttpSession m_aHttpSession;

    public SessionWebScope(@Nonnull HttpSession httpSession) {
        super(httpSession.getId());
        this.m_aHttpSession = httpSession;
        this.attrs().beforeSetValueCallbacks().add((string, object) -> {
            if (object != null && !(object instanceof Serializable)) {
                LOGGER.warn("Value of class " + object.getClass().getName() + " should implement Serializable!");
            }
            return EContinue.CONTINUE;
        });
    }

    @Override
    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Override
    public void initScope() {
        Enumeration<String> enumeration = this.m_aHttpSession.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Object object = this.m_aHttpSession.getAttribute(string);
                this.attrs().putIn(string, object);
            }
        }
    }

    @Override
    @Nonnull
    public EContinue selfDestruct() {
        try {
            this.m_aHttpSession.invalidate();
            return EContinue.BREAK;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("Session '" + this.getID() + "' was already invalidated, but was still contained!");
            return EContinue.CONTINUE;
        }
    }

    @Override
    @Nonnull
    public HttpSession getSession() {
        return this.m_aHttpSession;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("HttpSession", this.m_aHttpSession).getToString();
    }
}

