/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.multipart;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.state.ICloseable;
import com.helger.commons.system.SystemHelper;
import com.helger.web.multipart.MultipartIllegalBoundaryException;
import com.helger.web.multipart.MultipartItemSkippedException;
import com.helger.web.multipart.MultipartMalformedStreamException;
import com.helger.web.multipart.MultipartProgressNotifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultipartStream
implements Serializable {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 20480;
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    private static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final transient InputStream m_aIS;
    private int m_nBoundaryLength;
    private final int m_nKeepRegion;
    private final byte[] m_aBoundary;
    private final int m_nBufSize;
    private final byte[] m_aBuffer;
    private int m_nHead;
    private int m_nTail;
    private String m_sHeaderEncoding;
    private final MultipartProgressNotifier m_aNotifier;

    public MultipartStream(InputStream inputStream, byte[] byArray, int n, MultipartProgressNotifier multipartProgressNotifier) {
        this.m_aIS = inputStream;
        this.m_nBufSize = n;
        this.m_aBuffer = new byte[n];
        this.m_aNotifier = multipartProgressNotifier;
        this.m_aBoundary = new byte[byArray.length + BOUNDARY_PREFIX.length];
        this.m_nBoundaryLength = byArray.length + BOUNDARY_PREFIX.length;
        this.m_nKeepRegion = this.m_aBoundary.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.m_aBoundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(byArray, 0, this.m_aBoundary, BOUNDARY_PREFIX.length, byArray.length);
        this.m_nHead = 0;
        this.m_nTail = 0;
    }

    public MultipartStream(InputStream inputStream, byte[] byArray, MultipartProgressNotifier multipartProgressNotifier) {
        this(inputStream, byArray, 4096, multipartProgressNotifier);
    }

    @Nullable
    public String getHeaderEncoding() {
        return this.m_sHeaderEncoding;
    }

    public void setHeaderEncoding(@Nullable String string) {
        this.m_sHeaderEncoding = string;
    }

    public byte readByte() throws IOException {
        if (this.m_nHead == this.m_nTail) {
            this.m_nHead = 0;
            this.m_nTail = this.m_aIS.read(this.m_aBuffer, this.m_nHead, this.m_nBufSize);
            if (this.m_nTail == -1) {
                throw new IOException("No more data is available");
            }
            if (this.m_aNotifier != null) {
                this.m_aNotifier.noteBytesRead(this.m_nTail);
            }
        }
        return this.m_aBuffer[this.m_nHead++];
    }

    public boolean readBoundary() throws MultipartMalformedStreamException {
        boolean bl;
        block5: {
            byte[] byArray = new byte[2];
            bl = false;
            this.m_nHead += this.m_nBoundaryLength;
            try {
                byArray[0] = this.readByte();
                if (byArray[0] == 10) {
                    return true;
                }
                byArray[1] = this.readByte();
                if (ArrayHelper.startsWith(byArray, STREAM_TERMINATOR)) {
                    bl = false;
                    break block5;
                }
                if (ArrayHelper.startsWith(byArray, FIELD_SEPARATOR)) {
                    bl = true;
                    break block5;
                }
                throw new MultipartMalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (IOException iOException) {
                throw new MultipartMalformedStreamException("Stream ended unexpectedly", iOException);
            }
        }
        return bl;
    }

    public void setBoundary(@Nonnull byte[] byArray) throws MultipartIllegalBoundaryException {
        ValueEnforcer.notNull(byArray, "Boundary");
        if (byArray.length != this.m_nBoundaryLength - BOUNDARY_PREFIX.length) {
            throw new MultipartIllegalBoundaryException("The length of a boundary token can not be changed");
        }
        System.arraycopy(byArray, 0, this.m_aBoundary, BOUNDARY_PREFIX.length, byArray.length);
    }

    public String readHeaders() throws MultipartMalformedStreamException {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            int n = 0;
            int n2 = 0;
            while (n < HEADER_SEPARATOR.length) {
                byte by;
                try {
                    by = this.readByte();
                }
                catch (IOException iOException) {
                    throw new MultipartMalformedStreamException("Stream ended unexpectedly after " + n2 + " bytes", iOException);
                }
                if (++n2 > 20480) {
                    throw new MultipartMalformedStreamException("Header section has more than 20480 bytes (maybe it is not properly terminated)");
                }
                n = by == HEADER_SEPARATOR[n] ? ++n : 0;
                nonBlockingByteArrayOutputStream.write(by);
            }
            Charset charset = CharsetHelper.getCharsetFromNameOrDefault(this.m_sHeaderEncoding, SystemHelper.getSystemCharset());
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    public int readBodyData() throws IOException {
        int n;
        MultipartItemInputStream multipartItemInputStream = this.createInputStream();
        byte[] byArray = new byte[8192];
        int n2 = 0;
        do {
            if ((n = multipartItemInputStream.read(byArray)) <= 0) continue;
            n2 += n;
        } while (n >= 0);
        return n2;
    }

    @Nonnull
    public MultipartItemInputStream createInputStream() {
        return new MultipartItemInputStream();
    }

    public int discardBodyData() throws IOException {
        return this.readBodyData();
    }

    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.m_aBoundary, 2, this.m_aBoundary, 0, this.m_aBoundary.length - 2);
        this.m_nBoundaryLength = this.m_aBoundary.length - 2;
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MultipartMalformedStreamException multipartMalformedStreamException) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.m_aBoundary, 0, this.m_aBoundary, 2, this.m_aBoundary.length - 2);
            this.m_nBoundaryLength = this.m_aBoundary.length;
            this.m_aBoundary[0] = 13;
            this.m_aBoundary[1] = 10;
        }
    }

    @CheckForSigned
    protected int findByte(byte by, int n) {
        for (int i = n; i < this.m_nTail; ++i) {
            if (this.m_aBuffer[i] != by) continue;
            return i;
        }
        return -1;
    }

    protected int findSeparator() {
        int n;
        int n2 = 0;
        int n3 = this.m_nTail - this.m_nBoundaryLength;
        for (n = this.m_nHead; n <= n3 && n2 != this.m_nBoundaryLength; ++n) {
            if ((n = this.findByte(this.m_aBoundary[0], n)) == -1 || n > n3) {
                return -1;
            }
            for (n2 = 1; n2 < this.m_nBoundaryLength && this.m_aBuffer[n + n2] == this.m_aBoundary[n2]; ++n2) {
            }
        }
        if (n2 == this.m_nBoundaryLength) {
            return n - 1;
        }
        return -1;
    }

    public final class MultipartItemInputStream
    extends InputStream
    implements ICloseable {
        private static final int BYTE_POSITIVE_OFFSET = 256;
        private long m_nTotal;
        private int m_nPad;
        private int m_nPos;
        private boolean m_bClosed;

        MultipartItemInputStream() {
            this._findSeparator();
        }

        private void _findSeparator() {
            this.m_nPos = MultipartStream.this.findSeparator();
            if (this.m_nPos == -1) {
                this.m_nPad = MultipartStream.this.m_nTail - MultipartStream.this.m_nHead > MultipartStream.this.m_nKeepRegion ? MultipartStream.this.m_nKeepRegion : MultipartStream.this.m_nTail - MultipartStream.this.m_nHead;
            }
        }

        public long getBytesRead() {
            return this.m_nTotal;
        }

        @Override
        public int available() throws IOException {
            if (this.m_nPos == -1) {
                return MultipartStream.this.m_nTail - MultipartStream.this.m_nHead - this.m_nPad;
            }
            return this.m_nPos - MultipartStream.this.m_nHead;
        }

        @Override
        public int read() throws IOException {
            if (this.m_bClosed) {
                throw new MultipartItemSkippedException();
            }
            if (this.available() == 0 && this._makeAvailable() == 0) {
                return -1;
            }
            ++this.m_nTotal;
            byte by = MultipartStream.this.m_aBuffer[MultipartStream.this.m_nHead++];
            if (by >= 0) {
                return by;
            }
            return by + 256;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.m_bClosed) {
                throw new MultipartItemSkippedException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.available();
            if (n3 == 0 && (n3 = this._makeAvailable()) == 0) {
                return -1;
            }
            n3 = Math.min(n3, n2);
            System.arraycopy(MultipartStream.this.m_aBuffer, MultipartStream.this.m_nHead, byArray, n, n3);
            MultipartStream.this.m_nHead = MultipartStream.this.m_nHead + n3;
            this.m_nTotal += (long)n3;
            return n3;
        }

        @Override
        public void close() throws IOException {
            this.close(false);
        }

        @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
        public void close(boolean bl) throws IOException {
            if (this.m_bClosed) {
                return;
            }
            if (bl) {
                this.m_bClosed = true;
                MultipartStream.this.m_aIS.close();
            } else {
                int n;
                while ((n = this.available()) != 0 || (n = this._makeAvailable()) != 0) {
                    this.skip(n);
                }
            }
            this.m_bClosed = true;
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.m_bClosed) {
                throw new MultipartItemSkippedException();
            }
            int n = this.available();
            if (n == 0 && (n = this._makeAvailable()) == 0) {
                return 0L;
            }
            long l2 = Math.min((long)n, l);
            MultipartStream.this.m_nHead = (int)((long)MultipartStream.this.m_nHead + l2);
            return l2;
        }

        private int _makeAvailable() throws IOException {
            int n;
            if (this.m_nPos != -1) {
                return 0;
            }
            this.m_nTotal += (long)(MultipartStream.this.m_nTail - MultipartStream.this.m_nHead - this.m_nPad);
            System.arraycopy(MultipartStream.this.m_aBuffer, MultipartStream.this.m_nTail - this.m_nPad, MultipartStream.this.m_aBuffer, 0, this.m_nPad);
            MultipartStream.this.m_nHead = 0;
            MultipartStream.this.m_nTail = this.m_nPad;
            do {
                int n2;
                if ((n2 = MultipartStream.this.m_aIS.read(MultipartStream.this.m_aBuffer, MultipartStream.this.m_nTail, MultipartStream.this.m_nBufSize - MultipartStream.this.m_nTail)) == -1) {
                    throw new MultipartMalformedStreamException("Stream ended unexpectedly");
                }
                if (MultipartStream.this.m_aNotifier != null) {
                    MultipartStream.this.m_aNotifier.noteBytesRead(n2);
                }
                MultipartStream.this.m_nTail = MultipartStream.this.m_nTail + n2;
                this._findSeparator();
            } while ((n = this.available()) <= 0 && this.m_nPos == -1);
            return n;
        }

        @Override
        public boolean isClosed() {
            return this.m_bClosed;
        }
    }
}

