/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.web.fileupload.io.AbstractThresholdingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class DeferredFileOutputStream
extends AbstractThresholdingOutputStream {
    private NonBlockingByteArrayOutputStream m_aMemoryOS;
    private OutputStream m_aCurrentOS;
    private final File m_aOutputFile;
    private boolean m_bClosed = false;

    public DeferredFileOutputStream(@Nonnegative int n, @Nonnull File file) {
        super(n);
        this.m_aOutputFile = ValueEnforcer.notNull(file, "OutputFile");
        this.m_aMemoryOS = new NonBlockingByteArrayOutputStream();
        this.m_aCurrentOS = this.m_aMemoryOS;
    }

    @Override
    protected OutputStream getStream() throws IOException {
        return this.m_aCurrentOS;
    }

    @Override
    protected void onThresholdReached() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.m_aOutputFile);
            this.m_aMemoryOS.writeTo(fileOutputStream);
            this.m_aCurrentOS = fileOutputStream;
            StreamHelper.close(this.m_aMemoryOS);
            this.m_aMemoryOS = null;
        }
        catch (IOException iOException) {
            StreamHelper.close(fileOutputStream);
            throw iOException;
        }
    }

    @Nullable
    public final NonBlockingByteArrayOutputStream getMemoryOS() {
        return this.m_aMemoryOS;
    }

    public boolean isInMemory() {
        return this.m_aMemoryOS != null;
    }

    @Nullable
    @ReturnsMutableCopy
    public byte[] getData() {
        if (this.m_aMemoryOS != null) {
            return this.m_aMemoryOS.toByteArray();
        }
        return null;
    }

    @Nonnegative
    public int getDataLength() {
        if (this.m_aMemoryOS != null) {
            return this.m_aMemoryOS.size();
        }
        return 0;
    }

    @Nonnull
    public File getFile() {
        return this.m_aOutputFile;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.m_bClosed = true;
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        if (!this.m_bClosed) {
            throw new IOException("This stream is not closed");
        }
        if (this.isInMemory()) {
            this.m_aMemoryOS.writeTo(outputStream);
        } else {
            FileInputStream fileInputStream = FileHelper.getInputStream(this.m_aOutputFile);
            StreamHelper.copyInputStreamToOutputStream(fileInputStream, outputStream);
        }
    }
}

