/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.io;

import com.helger.commons.ValueEnforcer;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class AbstractThresholdingOutputStream
extends OutputStream {
    private final int m_nThreshold;
    private long m_nWritten;
    private boolean m_bThresholdExceeded;

    public AbstractThresholdingOutputStream(@Nonnegative int n) {
        this.m_nThreshold = ValueEnforcer.isGT0(n, "Threshold");
    }

    @Override
    public void write(int n) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(n);
        ++this.m_nWritten;
    }

    @Override
    public void write(@Nonnull byte[] byArray) throws IOException {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.m_nWritten += (long)byArray.length;
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.checkThreshold(n2);
        this.getStream().write(byArray, n, n2);
        this.m_nWritten += (long)n2;
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    @Nonnegative
    public int getThreshold() {
        return this.m_nThreshold;
    }

    public long getByteCount() {
        return this.m_nWritten;
    }

    public boolean isThresholdExceeded() {
        return this.m_nWritten > (long)this.m_nThreshold;
    }

    protected void checkThreshold(int n) throws IOException {
        if (!this.m_bThresholdExceeded && this.m_nWritten + (long)n > (long)this.m_nThreshold) {
            this.m_bThresholdExceeded = true;
            this.onThresholdReached();
        }
    }

    protected void resetByteCount() {
        this.m_bThresholdExceeded = false;
        this.m_nWritten = 0L;
    }

    @Nonnull
    protected abstract OutputStream getStream() throws IOException;

    protected abstract void onThresholdReached() throws IOException;
}

