/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.useragent.IUserAgent;
import com.helger.useragent.UserAgentDecryptor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UserAgentDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentDatabase.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsSet<String> s_aUniqueUserAgents = new CommonsHashSet<String>();
    @GuardedBy(value="s_aRWLock")
    private static Consumer<? super IUserAgent> s_aNewUserAgentCallback;
    private static final UserAgentDatabase s_aInstance;

    private UserAgentDatabase() {
    }

    public static void setUserAgentCallback(@Nullable Consumer<? super IUserAgent> consumer) {
        s_aRWLock.writeLockedGet(() -> {
            s_aNewUserAgentCallback = consumer;
            return s_aNewUserAgentCallback;
        });
    }

    @Nullable
    public static IUserAgent getParsedUserAgent(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        IUserAgent iUserAgent = UserAgentDecryptor.decryptUserAgentString(string);
        boolean bl = s_aRWLock.writeLockedBoolean(() -> s_aUniqueUserAgents.add(string));
        if (bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found new UserAgent '" + string + "'");
            }
            s_aRWLock.readLocked(() -> {
                if (s_aNewUserAgentCallback != null) {
                    s_aNewUserAgentCallback.accept(iUserAgent);
                }
            });
        }
        return iUserAgent;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllUniqueUserAgents() {
        return s_aRWLock.readLockedGet(s_aUniqueUserAgents::getClone);
    }

    static {
        s_aInstance = new UserAgentDatabase();
    }
}

