/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.useragent.ApplicationUserAgentManager;
import com.helger.useragent.IUserAgent;
import com.helger.useragent.UserAgentElementList;
import com.helger.useragent.browser.BrowserInfo;
import com.helger.useragent.browser.BrowserInfoIE;
import com.helger.useragent.browser.BrowserInfoMobile;
import com.helger.useragent.browser.BrowserInfoSpider;
import com.helger.useragent.browser.EBrowserType;
import com.helger.useragent.browser.MobileBrowserManager;
import com.helger.useragent.spider.WebSpiderInfo;
import com.helger.useragent.spider.WebSpiderManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserAgent
implements IUserAgent {
    private static final String GECKO_SEARCH_STRING = "Gecko";
    private static final String LYNX_SEARCH_STRING = "Lynx";
    private static final String CHROME_SEARCH_STRING = "Chrome";
    private static final String VERSION_SEARCH_STRING = "Version";
    private static final String SAFARI_SEARCH_STRING = "Safari";
    private static final String OPERA_SEARCH_STRING = "Opera";
    private static final String FIREFOX_SEARCH_STRING = "Firefox";
    private static final String VIVALDI_SEARCH_STRING = "Vivaldi";
    private static final String IE_SEARCH_STRING = "MSIE";
    private static final String IE_TRIDENT_SEARCH_STRING = "Trident/";
    private static final String IE_RV_SEARCH_STRING = "rv:";
    private static final String KONQUEROR_PREFIX = "Konqueror/";
    private static final String[] GECKO_VARIANTS = new String[]{"GranParadiso", "Fedora", "Namoroka", "Netscape", "K-Meleon", "WebThumb"};
    private static final int IE_VERSION_IN_COMPATIBILITY_MODE = 7;
    private final String m_sFullUserAgent;
    private final UserAgentElementList m_aElements;
    private BrowserInfo m_aInfoFirefox;
    private BrowserInfoIE m_aInfoIE;
    private BrowserInfo m_aInfoOpera;
    private BrowserInfo m_aInfoSafari;
    private BrowserInfo m_aInfoChrome;
    private BrowserInfo m_aInfoVivaldi;
    private BrowserInfo m_aInfoLynx;
    private BrowserInfo m_aInfoKonqueror;
    private BrowserInfo m_aInfoGeckoBased;
    private BrowserInfo m_aInfoWebKitBased;
    private BrowserInfoMobile m_aInfoMobile;
    private BrowserInfoSpider m_aInfoWebSpider;
    private BrowserInfo m_aInfoApplication;

    public UserAgent(@Nonnull String string, @Nonnull UserAgentElementList userAgentElementList) {
        this.m_sFullUserAgent = ValueEnforcer.notNull(string, "FullUserAgent");
        this.m_aElements = ValueEnforcer.notNull(userAgentElementList, "Elements");
    }

    @Override
    @Nonnull
    public String getAsString() {
        return this.m_sFullUserAgent;
    }

    @Override
    @Nullable
    public BrowserInfo getBrowserInfo() {
        if (this.getInfoFirefox().isIt()) {
            return this.getInfoFirefox();
        }
        if (this.getInfoIE().isIt()) {
            return this.getInfoIE();
        }
        if (this.getInfoOpera().isIt()) {
            return this.getInfoOpera();
        }
        if (this.getInfoSafari().isIt()) {
            return this.getInfoSafari();
        }
        if (this.getInfoChrome().isIt()) {
            return this.getInfoChrome();
        }
        if (this.getInfoVivaldi().isIt()) {
            return this.getInfoVivaldi();
        }
        if (this.getInfoLynx().isIt()) {
            return this.getInfoLynx();
        }
        if (this.getInfoKonqueror().isIt()) {
            return this.getInfoKonqueror();
        }
        if (this.getInfoGeckoBased().isIt()) {
            return this.getInfoGeckoBased();
        }
        if (this.getInfoWebKitBased().isIt()) {
            return this.getInfoWebKitBased();
        }
        if (this.getInfoMobile().isIt()) {
            return this.getInfoMobile();
        }
        if (this.getInfoWebSpider().isIt()) {
            return this.getInfoWebSpider();
        }
        if (this.getInfoApplication().isIt()) {
            return this.getInfoApplication();
        }
        return null;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoFirefox() {
        if (this.m_aInfoFirefox == null) {
            String string = this.m_aElements.getPairValue(FIREFOX_SEARCH_STRING);
            if (string == null) {
                string = this.m_aElements.getStringValueFollowing(FIREFOX_SEARCH_STRING);
            }
            this.m_aInfoFirefox = string == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.FIREFOX, Version.parse(string));
        }
        return this.m_aInfoFirefox;
    }

    @Override
    @Nonnull
    public BrowserInfoIE getInfoIE() {
        if (this.m_aInfoIE == null) {
            String string = this.m_aElements.getListItemStartingWith(IE_SEARCH_STRING);
            String string2 = this.m_aElements.getListItemStartingWith(IE_TRIDENT_SEARCH_STRING);
            if (this.m_aElements.containsString(OPERA_SEARCH_STRING)) {
                string = null;
            }
            if (string == null) {
                if (string2 != null) {
                    String string3 = this.m_aElements.getListItemStartingWith(IE_RV_SEARCH_STRING);
                    if (string3 != null) {
                        Version version = Version.parse(string3.substring(IE_RV_SEARCH_STRING.length()));
                        this.m_aInfoIE = new BrowserInfoIE(version, false);
                    } else {
                        this.m_aInfoIE = BrowserInfoIE.IS_IT_NOT_IE;
                    }
                } else {
                    this.m_aInfoIE = BrowserInfoIE.IS_IT_NOT_IE;
                }
            } else {
                Version version = Version.parse(string.substring(IE_SEARCH_STRING.length()).trim());
                boolean bl = version.getMajor() == 7 && string2 != null;
                this.m_aInfoIE = new BrowserInfoIE(version, bl);
            }
        }
        return this.m_aInfoIE;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoOpera() {
        if (this.m_aInfoOpera == null) {
            String string = this.m_aElements.getPairValue(OPERA_SEARCH_STRING);
            if (string != null) {
                String string2 = this.m_aElements.getPairValue(VERSION_SEARCH_STRING);
                if (string2 != null) {
                    string = string2;
                }
            } else {
                string = this.m_aElements.getStringValueFollowing(OPERA_SEARCH_STRING);
            }
            this.m_aInfoOpera = string == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.OPERA, Version.parse(string));
        }
        return this.m_aInfoOpera;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoSafari() {
        if (this.m_aInfoSafari == null) {
            String string = this.m_aElements.getPairValue(SAFARI_SEARCH_STRING);
            String string2 = string == null ? null : this.m_aElements.getPairValue(VERSION_SEARCH_STRING);
            this.m_aInfoSafari = string2 == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.SAFARI, Version.parse(string2));
        }
        return this.m_aInfoSafari;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoChrome() {
        if (this.m_aInfoChrome == null) {
            String string = this.m_aElements.getPairValue(SAFARI_SEARCH_STRING);
            String string2 = string == null ? null : this.m_aElements.getPairValue(CHROME_SEARCH_STRING);
            this.m_aInfoChrome = string2 == null || this.m_aElements.getPairValue(VIVALDI_SEARCH_STRING) != null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.CHROME, Version.parse(string2));
        }
        return this.m_aInfoChrome;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoVivaldi() {
        if (this.m_aInfoVivaldi == null) {
            String string = this.m_aElements.getPairValue(VIVALDI_SEARCH_STRING);
            this.m_aInfoVivaldi = string == null || this.m_aElements.getPairValue(CHROME_SEARCH_STRING) == null || this.m_aElements.getPairValue(SAFARI_SEARCH_STRING) == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.VIVALDI, Version.parse(string));
        }
        return this.m_aInfoVivaldi;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoLynx() {
        if (this.m_aInfoLynx == null) {
            String string = this.m_aElements.getPairValue(LYNX_SEARCH_STRING);
            this.m_aInfoLynx = string == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.LYNX, Version.parse(string));
        }
        return this.m_aInfoLynx;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoKonqueror() {
        if (this.m_aInfoKonqueror == null) {
            String string = this.m_aElements.getListItemStartingWith(KONQUEROR_PREFIX);
            this.m_aInfoKonqueror = string == null ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.KONQUEROR, Version.parse(string.substring(KONQUEROR_PREFIX.length())));
        }
        return this.m_aInfoKonqueror;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoGeckoBased() {
        if (this.m_aInfoGeckoBased == null) {
            String string = this.m_aElements.getPairValue(GECKO_SEARCH_STRING);
            if (string == null && this.m_sFullUserAgent.contains(GECKO_SEARCH_STRING)) {
                String string2;
                String[] stringArray = GECKO_VARIANTS;
                int n = stringArray.length;
                for (int i = 0; i < n && (string = this.m_aElements.getPairValue(string2 = stringArray[i])) == null; ++i) {
                }
            }
            this.m_aInfoGeckoBased = string == null || this.getInfoFirefox().isIt() ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.GECKO, Version.parse(string));
        }
        return this.m_aInfoGeckoBased;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoWebKitBased() {
        if (this.m_aInfoWebKitBased == null) {
            String string = this.m_aElements.getPairValue("AppleWebKit");
            this.m_aInfoWebKitBased = string == null || this.getInfoSafari().isIt() || this.getInfoChrome().isIt() ? BrowserInfo.IS_IT_NOT : new BrowserInfo(EBrowserType.WEBKIT, Version.parse(string));
        }
        return this.m_aInfoWebKitBased;
    }

    @Override
    @Nonnull
    public BrowserInfoMobile getInfoMobile() {
        if (this.m_aInfoMobile == null) {
            String string = MobileBrowserManager.getFromUserAgent(this.m_sFullUserAgent);
            this.m_aInfoMobile = string == null ? BrowserInfoMobile.IS_IT_NOT_MOBILE : new BrowserInfoMobile(string);
        }
        return this.m_aInfoMobile;
    }

    @Override
    @Nonnull
    public BrowserInfoSpider getInfoWebSpider() {
        if (this.m_aInfoWebSpider == null) {
            WebSpiderInfo webSpiderInfo = WebSpiderManager.getInstance().getWebSpiderFromUserAgent(this.m_sFullUserAgent);
            this.m_aInfoWebSpider = webSpiderInfo == null ? BrowserInfoSpider.IS_IT_NOT_SPIDER : new BrowserInfoSpider(webSpiderInfo);
        }
        return this.m_aInfoWebSpider;
    }

    @Override
    @Nonnull
    public BrowserInfo getInfoApplication() {
        if (this.m_aInfoApplication == null) {
            String string = ApplicationUserAgentManager.getFromUserAgent(this.m_sFullUserAgent);
            this.m_aInfoApplication = string == null ? BrowserInfoSpider.IS_IT_NOT_SPIDER : new BrowserInfo(EBrowserType.APPLICATION, Version.DEFAULT_VERSION);
        }
        return this.m_aInfoApplication;
    }

    public String toString() {
        return new ToStringGenerator(this).append("FullUserAgent", this.m_sFullUserAgent).append("Elements", this.m_aElements).append(FIREFOX_SEARCH_STRING, this.getInfoFirefox()).append("IE", this.getInfoIE()).append(OPERA_SEARCH_STRING, this.getInfoOpera()).append(SAFARI_SEARCH_STRING, this.getInfoSafari()).append(CHROME_SEARCH_STRING, this.getInfoChrome()).append(VIVALDI_SEARCH_STRING, this.getInfoVivaldi()).append(LYNX_SEARCH_STRING, this.getInfoLynx()).append("Gecko based", this.getInfoGeckoBased()).append("Webkit based", this.getInfoWebKitBased()).append("Mobile", this.getInfoMobile()).append("WebSpider", this.getInfoWebSpider()).append("Application", this.getInfoApplication()).getToString();
    }
}

