/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.Base32Codec;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.StringHelper;
import com.helger.dns.naptr.NaptrResolver;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.smpclient.url.IBDXLURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.xbill.DNS.TextParseException;

@ThreadSafe
public class BDXLURLProvider
implements IBDXLURLProvider {
    public static final String DNS_UNAPTR_SERVICE_NAME_META_SMP = "Meta:SMP";
    public static final BDXLURLProvider MUTABLE_INSTANCE = new BDXLURLProvider();
    public static final IBDXLURLProvider INSTANCE = MUTABLE_INSTANCE;
    public static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    public static final Locale URL_LOCALE = Locale.US;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private boolean m_bLowercaseValueBeforeHashing = true;
    private final ICommonsMap<String, String> m_aDNSCache = new CommonsHashMap<String, String>();
    private boolean m_bUseDNSCache = true;

    @Override
    public boolean isLowercaseValueBeforeHashing() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bLowercaseValueBeforeHashing);
    }

    public void setLowercaseValueBeforeHashing(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bLowercaseValueBeforeHashing = bl;
            return this.m_bLowercaseValueBeforeHashing;
        });
    }

    @Override
    public boolean isUseDNSCache() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseDNSCache);
    }

    public void setUseDNSCache(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bUseDNSCache = bl;
            return this.m_bUseDNSCache;
        });
    }

    public void clearDNSCache() {
        this.m_aRWLock.writeLocked(this.m_aDNSCache::clear);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getAllDNSCacheEntries() {
        return this.m_aRWLock.readLockedGet(this.m_aDNSCache::getClone);
    }

    public void addCacheEntries(@Nullable Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.putAll(map));
        }
    }

    @Nonnull
    public static String getHashValueStringRepresentation(@Nonnull String string) {
        byte[] byArray = MessageDigestValue.create(string.getBytes(URL_CHARSET), EMessageDigestAlgorithm.SHA_256).bytes();
        return new Base32Codec().setAddPaddding(false).getEncodedAsString(byArray, StandardCharsets.ISO_8859_1);
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string, boolean bl, @Nullable List<InetAddress> list) throws PeppolDNSResolutionException {
        String string2;
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantIdentifier");
        if (StringHelper.hasText(string) && !StringHelper.endsWith((CharSequence)string, '.')) {
            throw new PeppolDNSResolutionException("if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = iParticipantIdentifier.getValue();
        if (this.m_bLowercaseValueBeforeHashing) {
            string3 = string3.toLowerCase(URL_LOCALE);
        }
        stringBuilder.append(BDXLURLProvider.getHashValueStringRepresentation(string3)).append('.');
        if (iParticipantIdentifier.hasScheme()) {
            string2 = iParticipantIdentifier.getScheme();
            if (this.m_bLowercaseValueBeforeHashing) {
                string2 = string2.toLowerCase(URL_LOCALE);
            }
            stringBuilder.append(string2).append('.');
        }
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        string2 = stringBuilder.toString();
        if (!bl) {
            return string2;
        }
        boolean bl2 = this.isUseDNSCache();
        try {
            String string4;
            String string5 = string4 = bl2 ? this.m_aRWLock.readLockedGet(() -> (String)this.m_aDNSCache.get(string2)) : null;
            if (string4 == null) {
                string4 = NaptrResolver.resolveFromUNAPTR(string2, list, DNS_UNAPTR_SERVICE_NAME_META_SMP);
                if (string4 == null) {
                    throw new PeppolDNSResolutionException("Failed to resolve '" + string2 + "' from DNS NAPTR");
                }
                string4 = StringHelper.trimStart(string4, "http://");
                string4 = StringHelper.trimStart(string4, "https://");
                if (bl2) {
                    String string6 = string4;
                    this.m_aRWLock.writeLockedGet(() -> this.m_aDNSCache.put(string2, string6));
                }
            }
            return string4;
        }
        catch (TextParseException textParseException) {
            throw new PeppolDNSResolutionException("Failed to parse '" + string2 + "'", textParseException);
        }
    }
}

