/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.smpclient.peppol.jaxb.EndpointType;
import com.helger.smpclient.peppol.jaxb.SignedServiceMetadataType;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ISMPServiceMetadataProvider {
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier var1, @Nonnull IDocumentTypeIdentifier var2) throws SMPClientException;

    @Nullable
    default public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcessID");
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        SignedServiceMetadataType signedServiceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return signedServiceMetadataType == null ? null : SMPClientReadOnly.getEndpoint(signedServiceMetadataType, iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    default public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return SMPClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public String getEndpointCertificateString(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return SMPClientReadOnly.getEndpointCertificateString(endpointType);
    }

    @Nullable
    default public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        String string = this.getEndpointCertificateString(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertStringToCertficate(string);
    }
}

