/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.smpclient.config.SMPClientConfiguration;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.httpclient.AbstractSMPResponseHandler;
import com.helger.smpclient.security.TrustStoreBasedX509KeySelector;
import com.helger.xml.serialize.read.DOMReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SMPHttpResponseHandlerSigned<T>
extends AbstractSMPResponseHandler<T> {
    public static final boolean DEFAULT_VERIFY_SIGNATURE = true;
    @Deprecated
    @DevelopersNote(value="since 8.0.3")
    public static final boolean DEFAULT_CHECK_CERTIFICATE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPHttpResponseHandlerSigned.class);
    private final GenericJAXBMarshaller<T> m_aMarshaller;
    private boolean m_bVerifySignature = true;
    private KeyStore m_aTrustStore;

    @Deprecated
    public SMPHttpResponseHandlerSigned(@Nonnull GenericJAXBMarshaller<T> genericJAXBMarshaller) {
        this(genericJAXBMarshaller, SMPClientConfiguration.loadTrustStore());
    }

    public SMPHttpResponseHandlerSigned(@Nonnull GenericJAXBMarshaller<T> genericJAXBMarshaller, @Nullable KeyStore keyStore) {
        this.m_aMarshaller = ValueEnforcer.notNull(genericJAXBMarshaller, "Marshaller");
        this.m_aTrustStore = keyStore;
    }

    @Deprecated
    public final boolean isCheckCertificate() {
        return this.isVerifySignature();
    }

    public final boolean isVerifySignature() {
        return this.m_bVerifySignature;
    }

    @Deprecated
    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setCheckCertificate(boolean bl) {
        return this.setVerifySignature(bl);
    }

    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setVerifySignature(boolean bl) {
        this.m_bVerifySignature = bl;
        return this;
    }

    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setTrustStore(@Nonnull KeyStore keyStore) {
        ValueEnforcer.notNull(keyStore, "TrustStore");
        this.m_aTrustStore = keyStore;
        return this;
    }

    private static boolean _checkSignature(@Nonnull @WillNotClose InputStream inputStream, @Nonnull KeyStore keyStore) throws MarshalException, XMLSignatureException {
        Document document = DOMReader.readXMLDOM(inputStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new IllegalArgumentException("Element <Signature> not found in SMP XML response");
        }
        TrustStoreBasedX509KeySelector trustStoreBasedX509KeySelector = new TrustStoreBasedX509KeySelector(keyStore);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(trustStoreBasedX509KeySelector, nodeList.item(0));
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
        boolean bl = xMLSignature.validate(dOMValidateContext);
        if (bl) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Signature validation was successful");
            }
        } else {
            LOGGER.info("Signature failed core validation");
            boolean bl2 = xMLSignature.getSignatureValue().validate(dOMValidateContext);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("  Signature value valid: " + bl2);
            }
            if (!bl2) {
                int n = 0;
                Iterator<Reference> iterator2 = xMLSignature.getSignedInfo().getReferences().iterator();
                while (iterator2.hasNext()) {
                    boolean bl3 = iterator2.next().validate(dOMValidateContext);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("  Reference[" + n + "] validity status: " + (bl3 ? "valid" : "NOT valid!"));
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws SMPClientBadResponseException, IOException {
        Object object;
        byte[] byArray;
        block19: {
            byArray = StreamHelper.getAllBytes(httpEntity.getContent());
            if (ArrayHelper.isEmpty(byArray)) {
                throw new SMPClientBadResponseException("Could not read SMP server response content");
            }
            if (this.m_bVerifySignature) {
                if (this.m_aTrustStore == null) {
                    throw new SMPClientBadResponseException("No trust store was configured - cannot verify signatures");
                }
                try {
                    object = new NonBlockingByteArrayInputStream(byArray);
                    Throwable throwable = null;
                    try {
                        if (!SMPHttpResponseHandlerSigned._checkSignature(object, this.m_aTrustStore)) {
                            throw new SMPClientBadResponseException("Signature returned from SMP server was not valid");
                        }
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new SMPClientBadResponseException("Error in validating signature returned from SMP server", exception);
                }
            }
            LOGGER.warn("SMP response signature verification is disabled. This should not happen in production systems!");
        }
        object = this.m_aMarshaller.read(byArray);
        if (object == null) {
            throw new SMPClientBadResponseException("Malformed XML document returned from SMP server");
        }
        return (T)object;
    }
}

