/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.smpclient.exception.SMPClientBadResponseException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;

public abstract class AbstractSMPResponseHandler<T>
implements ResponseHandler<T> {
    @Nullable
    public abstract T handleEntity(@Nonnull HttpEntity var1) throws IOException, SMPClientBadResponseException;

    @Override
    @Nullable
    public T handleResponse(@Nonnull HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpEntity httpEntity = httpResponse.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        try {
            return httpEntity == null ? null : (T)this.handleEntity(httpEntity);
        }
        catch (SMPClientBadResponseException sMPClientBadResponseException) {
            throw new ClientProtocolException(sMPClientBadResponseException);
        }
    }
}

