/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.annotation.IsOffline;
import com.helger.servlet.request.RequestHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);
    private static final AnnotationUsageCache s_aOfflineCache = new AnnotationUsageCache(IsOffline.class);
    private static final RequestLogger s_aInstance = new RequestLogger();

    private RequestLogger() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getRequestFieldMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull(httpServletRequest, "HttpRequest");
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        if (s_aOfflineCache.hasAnnotation(httpServletRequest)) {
            commonsLinkedHashMap.put("Offline", "true");
        } else {
            commonsLinkedHashMap.put("AuthType", httpServletRequest.getAuthType());
            commonsLinkedHashMap.put("CharacterEncoding", httpServletRequest.getCharacterEncoding());
            commonsLinkedHashMap.put("ContentLength", Long.toString(RequestHelper.getContentLength(httpServletRequest)));
            commonsLinkedHashMap.put("ContentType", httpServletRequest.getContentType());
            commonsLinkedHashMap.put("ContextPath", ServletHelper.getRequestContextPath(httpServletRequest));
            commonsLinkedHashMap.put("ContextPath2", ServletContextPathHolder.getContextPathOrNull());
            commonsLinkedHashMap.put("LocalAddr", httpServletRequest.getLocalAddr());
            commonsLinkedHashMap.put("LocalName", httpServletRequest.getLocalName());
            commonsLinkedHashMap.put("LocalPort", Integer.toString(httpServletRequest.getLocalPort()));
            commonsLinkedHashMap.put("Method", httpServletRequest.getMethod());
            commonsLinkedHashMap.put("PathInfo", ServletHelper.getRequestPathInfo(httpServletRequest));
            commonsLinkedHashMap.put("PathInfo2", RequestHelper.getPathInfo(httpServletRequest));
            commonsLinkedHashMap.put("PathTranslated", httpServletRequest.getPathTranslated());
            commonsLinkedHashMap.put("Protocol", httpServletRequest.getProtocol());
            commonsLinkedHashMap.put("QueryString", ServletHelper.getRequestQueryString(httpServletRequest));
            commonsLinkedHashMap.put("RemoteAddr", httpServletRequest.getRemoteAddr());
            commonsLinkedHashMap.put("RemoteHost", httpServletRequest.getRemoteHost());
            commonsLinkedHashMap.put("RemotePort", Integer.toString(httpServletRequest.getRemotePort()));
            commonsLinkedHashMap.put("RemoteUser", httpServletRequest.getRemoteUser());
            commonsLinkedHashMap.put("RequestedSessionId", httpServletRequest.getRequestedSessionId());
            commonsLinkedHashMap.put("RequestURI", ServletHelper.getRequestRequestURI(httpServletRequest));
            commonsLinkedHashMap.put("RequestURI2", RequestHelper.getRequestURIDecoded(httpServletRequest));
            commonsLinkedHashMap.put("RequestURI3", RequestHelper.getRequestURIEncoded(httpServletRequest));
            commonsLinkedHashMap.put("RequestURL", ServletHelper.getRequestRequestURL(httpServletRequest).toString());
            commonsLinkedHashMap.put("RequestURL2", RequestHelper.getRequestURLDecoded(httpServletRequest).toString());
            commonsLinkedHashMap.put("RequestURL3", RequestHelper.getRequestURLEncoded(httpServletRequest).toString());
            commonsLinkedHashMap.put("Scheme", httpServletRequest.getScheme());
            commonsLinkedHashMap.put("ServerName", httpServletRequest.getServerName());
            commonsLinkedHashMap.put("ServerPort", Integer.toString(httpServletRequest.getServerPort()));
            commonsLinkedHashMap.put("ServletPath", ServletHelper.getRequestServletPath(httpServletRequest));
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            commonsLinkedHashMap.put("SessionID", httpSession.getId());
        }
        return commonsLinkedHashMap;
    }

    public static void debugAppendRequestFields(@Nonnull Map<String, String> map, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Request:\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("  ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
    }

    public static void debugAppendRequestHeader(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Headers:\n");
        httpHeaderMap.forEachHeaderLine(string -> stringBuilder.append("  ").append((String)string).append('\n'), true);
    }

    @Nonnull
    public static ICommonsOrderedMap<String, String> getRequestParameterMap(@Nonnull HttpServletRequest httpServletRequest) {
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (Map.Entry entry : CollectionHelper.getSortedByKey(httpServletRequest.getParameterMap()).entrySet()) {
            commonsLinkedHashMap.put(entry.getKey(), StringHelper.getImploded(", ", (Object[])entry.getValue()));
        }
        return commonsLinkedHashMap;
    }

    public static void debugAppendRequestParameters(@Nonnull Map<String, String> map, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Request parameters:\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("  ").append(entry.getKey()).append(" = '").append(entry.getValue()).append("'\n");
        }
    }

    @Nonnull
    public static String getCookieValue(@Nonnull Cookie cookie) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cookie.getValue());
        if (StringHelper.hasText(cookie.getDomain())) {
            stringBuilder.append(" [domain=").append(cookie.getDomain()).append(']');
        }
        stringBuilder.append(" [maxage=").append(cookie.getMaxAge()).append(']');
        if (StringHelper.hasText(cookie.getPath())) {
            stringBuilder.append(" [path=").append(cookie.getPath()).append(']');
        }
        if (cookie.getSecure()) {
            stringBuilder.append(" [secure]");
        }
        stringBuilder.append(" [version=").append(cookie.getVersion()).append(']');
        if (StringHelper.hasText(cookie.getComment())) {
            stringBuilder.append(" [comment=").append(cookie.getComment()).append(']');
        }
        if (cookie.isHttpOnly()) {
            stringBuilder.append(" [http-only]");
        }
        return stringBuilder.toString();
    }

    public static void debugAppendRequestCookies(@Nonnull HttpServletRequest httpServletRequest, @Nonnull StringBuilder stringBuilder) {
        stringBuilder.append("Cookies:\n");
        Cookie[] cookieArray = ServletHelper.getRequestCookies(httpServletRequest);
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                stringBuilder.append("  ").append(cookie.getName()).append(" = ").append(RequestLogger.getCookieValue(cookie)).append('\n');
            }
        }
    }

    @Nonnull
    public static StringBuilder getRequestDebugString(@Nonnull HttpServletRequest httpServletRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        RequestLogger.debugAppendRequestFields(RequestLogger.getRequestFieldMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestHeader(RequestHelper.getRequestHeaderMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestParameters(RequestLogger.getRequestParameterMap(httpServletRequest), stringBuilder);
        RequestLogger.debugAppendRequestCookies(httpServletRequest, stringBuilder);
        return stringBuilder;
    }

    public static void logRequestComplete(@Nonnull HttpServletRequest httpServletRequest) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(RequestLogger.getRequestDebugString(httpServletRequest).toString());
        }
    }
}

