/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.iterate.EmptyEnumeration;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceprovider.DefaultResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.lang.priviledged.IPrivilegedAction;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.mock.MockHttpListener;
import com.helger.servlet.mock.MockHttpServletResponse;
import com.helger.servlet.mock.MockRequestDispatcher;
import com.helger.servlet.mock.MockServletConfig;
import com.helger.servlet.mock.MockServletPool;
import com.helger.servlet.spec.IServletContext310To400Migration;
import com.helger.xml.util.mime.MimeTypeInfoManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockServletContext
implements IServletContext310To400Migration {
    public static final int SERVLET_SPEC_MAJOR_VERSION = 3;
    public static final int SERVLET_SPEC_MINOR_VERSION = 0;
    public static final String DEFAULT_SERVLET_CONTEXT_NAME = "MockServletContext";
    public static final String DEFAULT_SERVLET_CONTEXT_PATH = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(MockServletContext.class);
    private static final AtomicBoolean s_aReThrowListenerException = new AtomicBoolean(false);
    private final IReadableResourceProvider m_aResourceProvider;
    private final String m_sResourceBasePath;
    private String m_sContextPath;
    private final ICommonsMap<String, ServletContext> m_aContexts = new CommonsHashMap<String, ServletContext>();
    private final ICommonsOrderedMap<String, String> m_aInitParameters = new CommonsLinkedHashMap<String, String>();
    private final ICommonsMap<String, Object> m_aAttributes = new CommonsHashMap<String, Object>();
    private String m_sServletContextName = "MockServletContext";
    private final MockServletPool m_aServletPool;
    private boolean m_bInvalidated = false;

    public static boolean isReThrowListenerException() {
        return s_aReThrowListenerException.get();
    }

    public static void setReThrowListenerException(boolean bl) {
        s_aReThrowListenerException.set(bl);
    }

    protected MockServletContext(@Nullable String string, @Nullable String string2, @Nullable IReadableResourceProvider iReadableResourceProvider, @Nullable Map<String, String> map) {
        this.setContextPath(string);
        this.m_aResourceProvider = iReadableResourceProvider != null ? iReadableResourceProvider : new DefaultResourceProvider();
        this.m_sResourceBasePath = string2 != null ? string2 : DEFAULT_SERVLET_CONTEXT_PATH;
        String string3 = SystemProperties.getTmpDir();
        if (string3 != null) {
            this.setAttribute("tempdir", new File(string3));
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
        this.m_aServletPool = new MockServletPool(this);
    }

    @OverrideOnDemand
    protected void initListeners() {
        ServletContextEvent servletContextEvent = new ServletContextEvent(this);
        for (ServletContextListener servletContextListener : MockHttpListener.getAllServletContextListeners()) {
            try {
                servletContextListener.contextInitialized(servletContextEvent);
            }
            catch (RuntimeException runtimeException) {
                if (MockServletContext.isReThrowListenerException()) {
                    throw runtimeException;
                }
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Failed to call contextInitialized on " + servletContextListener, runtimeException);
            }
        }
    }

    @Nonnull
    protected String getResourceLocation(@Nonnull String string) {
        return StringHelper.startsWith((CharSequence)string, '/') ? this.m_sResourceBasePath + string : this.m_sResourceBasePath + "/" + string;
    }

    public final void setContextPath(@Nullable String string) {
        this.m_sContextPath = StringHelper.hasNoText(string) ? DEFAULT_SERVLET_CONTEXT_PATH : (StringHelper.startsWith((CharSequence)string, '/') ? string : '/' + string);
        ServletContextPathHolder.setServletContextPath(this.m_sContextPath);
    }

    @Override
    @Nonnull
    public String getContextPath() {
        return this.m_sContextPath;
    }

    public void registerContext(@Nonnull String string, @Nonnull ServletContext servletContext) {
        ValueEnforcer.notNull(string, "ContextPath");
        ValueEnforcer.notNull(servletContext, "Context");
        this.m_aContexts.put(string, servletContext);
    }

    @Override
    @Nullable
    public ServletContext getContext(@Nullable String string) {
        if (this.m_sContextPath.equals(string)) {
            return this;
        }
        return (ServletContext)this.m_aContexts.get(string);
    }

    @Override
    @Nonnegative
    public int getMajorVersion() {
        return 3;
    }

    @Override
    @Nonnegative
    public int getMinorVersion() {
        return 0;
    }

    @Override
    @Nullable
    public String getMimeType(@Nonnull String string) {
        return MimeTypeInfoManager.getDefaultInstance().getPrimaryMimeTypeStringForFilename(string);
    }

    @Deprecated
    public ICommonsSet<String> getResourcePaths(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public URL getResource(@Nonnull String string) throws MalformedURLException {
        IReadableResource iReadableResource = this.m_aResourceProvider.getReadableResource(this.getResourceLocation(string));
        if (!iReadableResource.exists()) {
            return null;
        }
        return iReadableResource.getAsURL();
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@Nonnull String string) {
        IReadableResource iReadableResource = this.m_aResourceProvider.getReadableResource(this.getResourceLocation(string));
        if (!iReadableResource.exists()) {
            return null;
        }
        return iReadableResource.getInputStream();
    }

    @Override
    @Nonnull
    public RequestDispatcher getRequestDispatcher(@Nonnull String string) {
        if (!StringHelper.startsWith((CharSequence)string, '/')) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(string);
    }

    @Override
    @Nullable
    @Deprecated
    public RequestDispatcher getNamedDispatcher(@Nullable String string) {
        return null;
    }

    @Override
    @Deprecated
    public Servlet getServlet(@Nullable String string) {
        return null;
    }

    @Override
    @Deprecated
    @Nonnull
    public Enumeration<Servlet> getServlets() {
        return new EmptyEnumeration<Servlet>();
    }

    @Override
    @Deprecated
    @Nonnull
    public Enumeration<String> getServletNames() {
        return new EmptyEnumeration<String>();
    }

    @Override
    public void log(@Nullable String string) {
        LOGGER.info(string);
    }

    @Override
    @Deprecated
    public void log(@Nullable Exception exception, @Nullable String string) {
        LOGGER.info(string, exception);
    }

    @Override
    public void log(@Nullable String string, @Nullable Throwable throwable) {
        LOGGER.info(string, throwable);
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public String getRealPath(@Nonnull String string) {
        IReadableResource iReadableResource = this.m_aResourceProvider.getReadableResource(this.getResourceLocation(string));
        if (iReadableResource == null) {
            throw new IllegalStateException("Failed to get real path of '" + string + "'");
        }
        File file = iReadableResource.getAsFile();
        if (file == null) {
            throw new IllegalStateException("Failed to convert resource " + iReadableResource + " to a file");
        }
        return file.getAbsolutePath();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getServerInfo() {
        return DEFAULT_SERVLET_CONTEXT_NAME;
    }

    @Override
    @Nullable
    public String getInitParameter(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return (String)this.m_aInitParameters.get(string);
    }

    public final void addInitParameter(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        this.m_aInitParameters.put(string, string2);
    }

    @Override
    @Nonnull
    public Enumeration<String> getInitParameterNames() {
        return IteratorHelper.getEnumeration(this.m_aInitParameters.keySet());
    }

    @Override
    @Nullable
    public Object getAttribute(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return this.m_aAttributes.get(string);
    }

    @Override
    @Nonnull
    public Enumeration<String> getAttributeNames() {
        return IteratorHelper.getEnumeration(this.m_aAttributes.keySet());
    }

    @Override
    public final void setAttribute(@Nonnull String string, @Nullable Object object) {
        ValueEnforcer.notNull(string, "Name");
        if (object != null) {
            this.m_aAttributes.put(string, object);
        } else {
            this.m_aAttributes.remove(string);
        }
    }

    @Override
    public void removeAttribute(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        this.m_aAttributes.remove(string);
    }

    public void setServletContextName(@Nullable String string) {
        this.m_sServletContextName = string;
    }

    @Override
    @Nullable
    public String getServletContextName() {
        return this.m_sServletContextName;
    }

    @Nonnull
    public MockServletConfig createServletConfig(@Nonnull @Nonempty String string) {
        return this.createServletConfig(string, null);
    }

    @Nonnull
    public MockServletConfig createServletConfig(@Nonnull @Nonempty String string, @Nullable Map<String, String> map) {
        return new MockServletConfig(this, string, map);
    }

    @Nonnull
    public MockServletPool getServletPool() {
        return this.m_aServletPool;
    }

    @Nullable
    public MockHttpServletResponse invoke(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull(httpServletRequest, "HttpRequest");
        String string = ServletHelper.getRequestServletPath(httpServletRequest);
        Servlet servlet = this.m_aServletPool.getServletOfPath(string);
        if (servlet == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Found no servlet matching '" + string + "'");
            }
            return null;
        }
        MockHttpServletResponse mockHttpServletResponse = new MockHttpServletResponse();
        try {
            servlet.service(httpServletRequest, mockHttpServletResponse);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to invoke servlet " + servlet + " for request " + httpServletRequest, exception);
        }
        return mockHttpServletResponse;
    }

    public void invalidate() {
        if (this.m_bInvalidated) {
            throw new IllegalStateException("Servlet context already invalidated!");
        }
        this.m_bInvalidated = true;
        this.m_aServletPool.invalidate();
        ServletContextEvent servletContextEvent = new ServletContextEvent(this);
        for (ServletContextListener servletContextListener : MockHttpListener.getAllServletContextListeners()) {
            try {
                servletContextListener.contextDestroyed(servletContextEvent);
            }
            catch (RuntimeException runtimeException) {
                if (MockServletContext.isReThrowListenerException()) {
                    throw runtimeException;
                }
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Failed to call contextDestroyed on " + servletContextListener, runtimeException);
            }
        }
        this.m_aAttributes.clear();
    }

    @Override
    public int getEffectiveMajorVersion() {
        return 3;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return 0;
    }

    @Override
    public boolean setInitParameter(String string, String string2) {
        this.addInitParameter(string, string2);
        return true;
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration getServletRegistration(String string) {
        throw new UnsupportedOperationException();
    }

    public ICommonsMap<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration getFilterRegistration(String string) {
        throw new UnsupportedOperationException();
    }

    public ICommonsMap<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        throw new UnsupportedOperationException();
    }

    public ICommonsSet<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    public ICommonsSet<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(Class<? extends EventListener> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getClassLoader() {
        return IPrivilegedAction.getClassLoader(this.getClass()).invokeSafe();
    }

    @Override
    public void declareRoles(String ... stringArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVirtualServerName() {
        return "Mock Server";
    }

    @Nonnull
    public static MockServletContext create() {
        return MockServletContext.create(null, DEFAULT_SERVLET_CONTEXT_PATH, null, null);
    }

    @Nonnull
    public static MockServletContext create(@Nullable Map<String, String> map) {
        return MockServletContext.create(null, DEFAULT_SERVLET_CONTEXT_PATH, null, map);
    }

    @Nonnull
    public static MockServletContext create(@Nullable String string) {
        return MockServletContext.create(string, DEFAULT_SERVLET_CONTEXT_PATH, null, null);
    }

    @Nonnull
    public static MockServletContext create(@Nullable String string, @Nullable Map<String, String> map) {
        return MockServletContext.create(string, DEFAULT_SERVLET_CONTEXT_PATH, null, map);
    }

    @Nonnull
    public static MockServletContext create(@Nullable String string, @Nullable String string2) {
        return MockServletContext.create(string, string2, null, null);
    }

    @Nonnull
    public static MockServletContext create(@Nullable String string, @Nullable String string2, @Nullable IReadableResourceProvider iReadableResourceProvider, @Nullable Map<String, String> map) {
        MockServletContext mockServletContext = new MockServletContext(string, string2, iReadableResourceProvider, map);
        mockServletContext.initListeners();
        return mockServletContext;
    }
}

