/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

@NotThreadSafe
public class MockServletConfig
implements ServletConfig {
    private final ServletContext m_aSC;
    private final String m_sServletName;
    private final ICommonsOrderedMap<String, String> m_aServletInitParams = new CommonsLinkedHashMap<String, String>();

    public MockServletConfig(@Nonnull ServletContext servletContext, @Nonnull @Nonempty String string) {
        this(servletContext, string, null);
    }

    public MockServletConfig(@Nonnull ServletContext servletContext, @Nonnull @Nonempty String string, @Nullable Map<String, String> map) {
        this.m_aSC = ValueEnforcer.notNull(servletContext, "ServletContext");
        this.m_sServletName = ValueEnforcer.notEmpty(string, "ServletName");
        if (map != null) {
            this.m_aServletInitParams.putAll(map);
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getServletName() {
        return this.m_sServletName;
    }

    @Override
    @Nonnull
    public ServletContext getServletContext() {
        return this.m_aSC;
    }

    @Override
    @Nullable
    public String getInitParameter(@Nullable String string) {
        return (String)this.m_aServletInitParams.get(string);
    }

    @Override
    @Nonnull
    public Enumeration<String> getInitParameterNames() {
        return IteratorHelper.getEnumeration(this.m_aServletInitParams.keySet());
    }

    public void addInitParameter(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(string2, "Value");
        this.m_aServletInitParams.put(string, string2);
    }

    @Nonnull
    public EChange removeInitParameter(@Nullable String string) {
        return EChange.valueOf(this.m_aServletInitParams.remove(string) != null);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllInitParameters() {
        return this.m_aServletInitParams.getClone();
    }

    public String toString() {
        return new ToStringGenerator(this).append("servletContext", this.m_aSC).append("servletName", this.m_sServletName).append("servletInitParams", this.m_aServletInitParams).getToString();
    }
}

