/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.logging;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class LoggingHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final LoggingServletOutpuStream m_aOS = new LoggingServletOutpuStream();
    private final HttpServletResponse m_aDelegate;

    public LoggingHttpServletResponseWrapper(@Nonnull HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.m_aDelegate = httpServletResponse;
    }

    @Override
    @Nonnull
    public ServletOutputStream getOutputStream() throws IOException {
        return this.m_aOS;
    }

    @Override
    @Nonnull
    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(StreamHelper.createWriter(this.m_aOS.m_aBAOS, this._getCharset()));
    }

    @Nonnull
    private Charset _getCharset() {
        String string = this.m_aDelegate.getCharacterEncoding();
        return CharsetHelper.getCharsetFromNameOrDefault(string, StandardCharsets.UTF_8);
    }

    @Nonnull
    public String getContentAsString() {
        return this.m_aOS.m_aBAOS.getAsString(this._getCharset());
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentAsBytes() {
        return this.m_aOS.m_aBAOS.toByteArray();
    }

    public void writeContentTo(@Nonnull OutputStream outputStream) throws IOException {
        if (!this.m_aDelegate.isCommitted() && this.m_aOS.m_aBAOS.isNotEmpty()) {
            this.m_aOS.m_aBAOS.writeTo(outputStream);
        }
    }

    private static class LoggingServletOutpuStream
    extends ServletOutputStream {
        private final NonBlockingByteArrayOutputStream m_aBAOS = new NonBlockingByteArrayOutputStream();

        private LoggingServletOutpuStream() {
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
        }

        @Override
        public void write(int n) throws IOException {
            this.m_aBAOS.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.m_aBAOS.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_aBAOS.write(byArray, n, n2);
        }
    }
}

