/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.async;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.functional.Predicates;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;

@Immutable
public class ServletAsyncSpec {
    public static final long NO_TIMEOUT = 0L;
    public static final ServletAsyncSpec SYNC_SPEC = new ServletAsyncSpec(false, 0L, null);
    private final boolean m_bAsynchronous;
    private final long m_nTimeoutMillis;
    private final ICommonsList<AsyncListener> m_aAsyncListeners;

    protected ServletAsyncSpec(boolean bl, @CheckForSigned long l, @Nullable Iterable<? extends AsyncListener> iterable) {
        if (!bl) {
            ValueEnforcer.isLE0(l, "TimeoutMillis");
            ValueEnforcer.isNull(iterable, "AsyncListeners");
        }
        this.m_bAsynchronous = bl;
        this.m_nTimeoutMillis = l;
        this.m_aAsyncListeners = new CommonsArrayList<Iterable<? extends AsyncListener>>(iterable);
    }

    @CheckForSigned
    public long getTimeoutMillis() {
        return this.m_nTimeoutMillis;
    }

    public boolean hasTimeoutMillis() {
        return this.m_nTimeoutMillis > 0L;
    }

    public boolean isAsynchronous() {
        return this.m_bAsynchronous;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<AsyncListener> getAllAsyncListeners() {
        return (ICommonsList)this.m_aAsyncListeners.getClone();
    }

    public boolean hasAsyncListeners() {
        return this.m_aAsyncListeners.isNotEmpty();
    }

    public void applyToAsyncContext(@Nonnull AsyncContext asyncContext) {
        if (!this.isAsynchronous()) {
            throw new IllegalStateException("This servlet is not declared asynchronous: " + this.toString());
        }
        if (this.hasAsyncListeners()) {
            for (AsyncListener asyncListener : this.m_aAsyncListeners) {
                asyncContext.addListener(asyncListener);
            }
        }
        if (this.hasTimeoutMillis()) {
            asyncContext.setTimeout(this.m_nTimeoutMillis);
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("Asynchronous", this.m_bAsynchronous).appendIf("TimeoutMillis", this.m_nTimeoutMillis, Predicates.longIsGT0()).append("AsyncListeners", this.m_aAsyncListeners).getToString();
    }

    @Nonnull
    public static ServletAsyncSpec getSync() {
        return SYNC_SPEC;
    }

    @Nonnull
    public static ServletAsyncSpec createAsync(@CheckForSigned long l, @Nullable Iterable<? extends AsyncListener> iterable) {
        return new ServletAsyncSpec(true, l, iterable);
    }

    @Nonnull
    public static ServletAsyncSpec createAsyncDefault() {
        return ServletAsyncSpec.createAsync(GlobalDebug.isDebugMode() ? 999999000L : 30000L, null);
    }
}

