/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.security.bcrypt.BCrypt;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import com.helger.security.password.salt.PasswordSaltBCrypt;
import javax.annotation.Nonnull;

public final class PasswordHashCreatorBCrypt
extends AbstractPasswordHashCreator {
    public static final String ALGORITHM = "BCrypt";

    public PasswordHashCreatorBCrypt() {
        super(ALGORITHM);
    }

    @Override
    public boolean requiresSalt() {
        return true;
    }

    @Override
    @Nonnull
    public String createPasswordHash(@Nonnull IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull(iPasswordSalt, "Salt");
        ValueEnforcer.isInstanceOf(iPasswordSalt, PasswordSaltBCrypt.class, "Salt");
        ValueEnforcer.notNull(string, "PlainTextPassword");
        return BCrypt.hashpw(string, iPasswordSalt.getSaltString());
    }
}

