/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.WrappedOutputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.crypto.Mac;

public class MacOutputStream
extends WrappedOutputStream {
    public static final boolean DEFAULT_ON = true;
    private Mac m_aMac;
    private boolean m_bOn = true;

    public MacOutputStream(@Nonnull OutputStream outputStream, @Nonnull Mac mac) {
        super(outputStream);
        this.setMac(mac);
    }

    @Nonnull
    public final Mac getMac() {
        return this.m_aMac;
    }

    public final void setMac(@Nonnull Mac mac) {
        ValueEnforcer.notNull(mac, "Mac");
        this.m_aMac = mac;
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        if (this.m_bOn) {
            this.m_aMac.update((byte)n);
        }
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this.m_bOn) {
            this.m_aMac.update(byArray, n, n2);
        }
    }

    public final void setOn(boolean bl) {
        this.m_bOn = bl;
    }

    public final boolean isOn() {
        return this.m_bOn;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Mac", this.m_aMac).append("On", this.m_bOn).getToString();
    }
}

