/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.mac;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.string.StringHelper;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public enum EMacAlgorithm {
    HMAC_MD5("HmacMD5"),
    HMAC_SHA1("HmacSHA1"),
    HMAC_SHA224("HmacSHA224"),
    HMAC_SHA256("HmacSHA256"),
    HMAC_SHA384("HmacSHA384"),
    HMAC_SHA512("HmacSHA512");

    private final String m_sAlgorithm;

    private EMacAlgorithm(String string2) {
        this.m_sAlgorithm = string2;
    }

    @Nonnull
    @Nonempty
    public String getAlgorithm() {
        return this.m_sAlgorithm;
    }

    @Nonnull
    public Mac createMac() {
        return this.createMac(null);
    }

    @Nonnull
    public Mac createMac(@Nullable Provider provider) {
        try {
            if (provider == null) {
                return Mac.getInstance(this.m_sAlgorithm);
            }
            return Mac.getInstance(this.m_sAlgorithm, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Failed to resolve Mac algorithm '" + this.m_sAlgorithm + "'", noSuchAlgorithmException);
        }
    }

    @Nonnull
    public SecretKeySpec createSecretKey(@Nonnull byte[] byArray) {
        return new SecretKeySpec(byArray, this.m_sAlgorithm);
    }

    @Nullable
    public static EMacAlgorithm getFromStringIgnoreCase(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return EnumHelper.findFirst(EMacAlgorithm.class, eMacAlgorithm -> eMacAlgorithm.m_sAlgorithm.equalsIgnoreCase(string));
    }
}

