/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resourceprovider.ClassPathResourceProvider;
import com.helger.commons.io.resourceprovider.FileSystemResourceProvider;
import com.helger.commons.io.resourceprovider.IReadableResourceProvider;
import com.helger.commons.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.security.keystore.EKeyStoreLoadError;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyStoreHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreHelper.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IReadableResourceProvider s_aResourceProvider = new ReadableResourceProviderChain(new FileSystemResourceProvider().setCanReadRelativePaths(true), new ClassPathResourceProvider());
    private static final KeyStoreHelper s_aInstance = new KeyStoreHelper();

    private KeyStoreHelper() {
    }

    @Nonnull
    public static IReadableResourceProvider getResourceProvider() {
        return s_aRWLock.readLockedGet(() -> s_aResourceProvider);
    }

    public static void setResourceProvider(@Nonnull IReadableResourceProvider iReadableResourceProvider) {
        ValueEnforcer.notNull(iReadableResourceProvider, "ResourceProvider");
        s_aRWLock.writeLockedGet(() -> {
            s_aResourceProvider = iReadableResourceProvider;
            return s_aResourceProvider;
        });
    }

    @Nonnull
    public static KeyStore getSimiliarKeyStore(@Nonnull KeyStore keyStore) throws KeyStoreException {
        return KeyStore.getInstance(keyStore.getType(), keyStore.getProvider());
    }

    @Nonnull
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull String string, @Nullable String string2) throws GeneralSecurityException, IOException {
        return KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, string2 == null ? null : string2.toCharArray());
    }

    @Nonnull
    public static KeyStore loadKeyStoreDirect(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull String string, @Nullable char[] cArray) throws GeneralSecurityException, IOException {
        ValueEnforcer.notNull(iKeyStoreType, "KeyStoreType");
        ValueEnforcer.notNull(string, "KeyStorePath");
        InputStream inputStream = KeyStoreHelper.getResourceProvider().getInputStream(string);
        if (inputStream == null) {
            throw new IllegalArgumentException("Failed to open key store '" + string + "'");
        }
        try {
            KeyStore keyStore = iKeyStoreType.getKeyStore();
            keyStore.load(inputStream, cArray);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalStateException("No provider can handle key stores of type " + iKeyStoreType, keyStoreException);
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Nonnull
    public static KeyStore createKeyStoreWithOnlyOneItem(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable char[] cArray) throws GeneralSecurityException, IOException {
        ValueEnforcer.notNull(keyStore, "BaseKeyStore");
        ValueEnforcer.notNull(string, "AliasToCopy");
        KeyStore keyStore2 = KeyStoreHelper.getSimiliarKeyStore(keyStore);
        keyStore2.load(null, null);
        KeyStore.PasswordProtection passwordProtection = null;
        if (cArray != null) {
            passwordProtection = new KeyStore.PasswordProtection(cArray);
        }
        keyStore2.setEntry(string, keyStore.getEntry(string, passwordProtection), passwordProtection);
        return keyStore2;
    }

    private static boolean _isInvalidPasswordException(@Nonnull Exception exception) {
        return exception instanceof IOException && exception.getCause() instanceof UnrecoverableKeyException;
    }

    @Nonnull
    public static LoadedKeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull(iKeyStoreType, "KeyStoreType");
        if (StringHelper.hasNoText(string)) {
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_NO_PATH, new String[0]);
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreHelper.loadKeyStoreDirect(iKeyStoreType, string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No such key store '" + string + "': " + illegalArgumentException.getMessage(), illegalArgumentException.getCause());
            }
            return new LoadedKeyStore(null, EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_NON_EXISTING, string, illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            boolean bl = KeyStoreHelper._isInvalidPasswordException(exception);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to load key store '" + string + "': " + exception.getMessage(), bl ? null : exception.getCause());
            }
            return new LoadedKeyStore(null, bl ? EKeyStoreLoadError.KEYSTORE_INVALID_PASSWORD : EKeyStoreLoadError.KEYSTORE_LOAD_ERROR_FORMAT_ERROR, string, exception.getMessage());
        }
        return new LoadedKeyStore(keyStore, null, new String[0]);
    }

    @Nonnull
    private static <T extends KeyStore.Entry> LoadedKey<T> _loadKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(keyStore, "KeyStore");
        ValueEnforcer.notNull(string, "KeyStorePath");
        ValueEnforcer.notNull(clazz, "TargetClass");
        if (StringHelper.hasNoText(string2)) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_ALIAS, string);
        }
        if (cArray == null) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_NO_PASSWORD, string2, string);
        }
        KeyStore.Entry entry = null;
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
            KeyStore.Entry entry2 = keyStore.getEntry(string2, passwordProtection);
            if (entry2 == null) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_ALIAS, string2, string);
            }
            if (!clazz.isAssignableFrom(entry2.getClass())) {
                return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_TYPE, string2, string, ClassHelper.getClassName(entry2));
            }
            entry = (KeyStore.Entry)clazz.cast(entry2);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_INVALID_PASSWORD, string2, string, unrecoverableKeyException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return new LoadedKey<Object>(null, EKeyStoreLoadError.KEY_LOAD_ERROR, string2, string, generalSecurityException.getMessage());
        }
        return new LoadedKey<KeyStore.Entry>(entry, null, new String[0]);
    }

    @Nonnull
    public static LoadedKey<KeyStore.PrivateKeyEntry> loadPrivateKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.PrivateKeyEntry.class);
    }

    @Nonnull
    public static LoadedKey<KeyStore.SecretKeyEntry> loadSecretKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.SecretKeyEntry.class);
    }

    @Nonnull
    public static LoadedKey<KeyStore.TrustedCertificateEntry> loadTrustedCertificateKey(@Nonnull KeyStore keyStore, @Nonnull String string, @Nullable String string2, @Nullable char[] cArray) {
        return KeyStoreHelper._loadKey(keyStore, string, string2, cArray, KeyStore.TrustedCertificateEntry.class);
    }
}

