/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StringInputStream;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CertificateHelper {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_CERTIFICATE_INVALID = "-----BEGINCERTIFICATE-----";
    public static final String END_CERTIFICATE_INVALID = "-----ENDCERTIFICATE-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String CRLF = "\r\n";
    public static final Charset CERT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateHelper.class);
    private static final CertificateHelper s_aInstance = new CertificateHelper();

    private CertificateHelper() {
    }

    @Nonnull
    public static CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    @Nonnull
    public static String getWithPEMHeader(@Nonnull String string) {
        String string2 = string;
        if (!string2.startsWith(BEGIN_CERTIFICATE)) {
            string2 = "-----BEGIN CERTIFICATE-----\n" + string2;
        }
        if (!string2.trim().endsWith(END_CERTIFICATE)) {
            string2 = string2 + "\n-----END CERTIFICATE-----";
        }
        return string2;
    }

    @Nullable
    public static String getWithoutPEMHeader(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = string.trim();
        string2 = StringHelper.trimStart(string2, BEGIN_CERTIFICATE_INVALID);
        string2 = StringHelper.trimEnd(string2, END_CERTIFICATE_INVALID);
        string2 = StringHelper.trimStart(string2, BEGIN_CERTIFICATE);
        string2 = StringHelper.trimEnd(string2, END_CERTIFICATE);
        return StringHelper.getWithoutAnySpaces(string2);
    }

    @Nullable
    public static String getRFC1421CompliantString(@Nullable String string, boolean bl) {
        return CertificateHelper.getRFC1421CompliantString(string, bl, CRLF);
    }

    @Nullable
    public static String getRFC1421CompliantString(@Nullable String string, boolean bl, @Nonnull String string2) {
        ValueEnforcer.notNull(string2, "LineSeparator");
        String string3 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.hasNoText(string3)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(BEGIN_CERTIFICATE).append('\n');
        }
        while (string3.length() > 64) {
            stringBuilder.append(string3, 0, 64).append(string2);
            string3 = string3.substring(64);
        }
        stringBuilder.append(string3);
        if (bl) {
            stringBuilder.append('\n').append(END_CERTIFICATE);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficate(@Nullable byte[] byArray) throws CertificateException {
        if (ArrayHelper.isEmpty(byArray)) {
            return null;
        }
        return CertificateHelper.convertStringToCertficate(new String(byArray, CERT_CHARSET));
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficateOrNull(@Nullable byte[] byArray) {
        try {
            return CertificateHelper.convertByteArrayToCertficate(byArray);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    @Nullable
    public static X509Certificate convertByteArrayToCertficateDirect(@Nullable byte[] byArray) throws CertificateException {
        if (ArrayHelper.isEmpty(byArray)) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(nonBlockingByteArrayInputStream);
            return x509Certificate;
        }
    }

    @Nonnull
    private static X509Certificate _str2cert(@Nonnull String string, @Nonnull CertificateFactory certificateFactory) throws CertificateException {
        String string2 = CertificateHelper.getRFC1421CompliantString(string, true);
        try (StringInputStream stringInputStream = new StringInputStream(string2, CERT_CHARSET);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(stringInputStream);
            return x509Certificate;
        }
    }

    @Nullable
    public static X509Certificate convertStringToCertficate(@Nullable String string) throws CertificateException {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
        try {
            return CertificateHelper._str2cert(string, certificateFactory);
        }
        catch (IllegalArgumentException | CertificateException exception) {
            String string2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to decode provided X.509 certificate string: " + string);
            }
            try {
                string2 = new String(StringHelper.getHexDecoded(string), CERT_CHARSET);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw exception;
            }
            return CertificateHelper._str2cert(string2, certificateFactory);
        }
    }

    @Nullable
    public static X509Certificate convertStringToCertficateOrNull(@Nullable String string) {
        try {
            return CertificateHelper.convertStringToCertficate(string);
        }
        catch (IllegalArgumentException | CertificateException exception) {
            return null;
        }
    }

    @Nullable
    public static byte[] convertCertificateStringToByteArray(@Nullable String string) {
        String string2 = CertificateHelper.getWithoutPEMHeader(string);
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        return Base64.safeDecode(string2);
    }

    @Nonnull
    @Nonempty
    public static String getPEMEncodedCertificate(@Nonnull Certificate certificate) {
        ValueEnforcer.notNull(certificate, "Cert");
        try {
            String string = Base64.encodeBytes(certificate.getEncoded());
            return "-----BEGIN CERTIFICATE-----\n" + string + "\n" + END_CERTIFICATE;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Failed to encode certificate " + certificate, certificateEncodingException);
        }
    }

    public static boolean isCertificateValidPerNow(@Nonnull X509Certificate x509Certificate) {
        ValueEnforcer.notNull(x509Certificate, "Cert");
        try {
            x509Certificate.checkValidity();
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
            return false;
        }
    }

    @Nullable
    public static PrivateKey convertStringToPrivateKey(@Nullable String string) throws GeneralSecurityException {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = StringHelper.trimStart(string, BEGIN_PRIVATE_KEY);
        string2 = StringHelper.trimEnd(string2, END_PRIVATE_KEY);
        byte[] byArray = Base64.safeDecode(string2 = StringHelper.getWithoutAnySpaces(string2));
        if (byArray == null) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }
}

