/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.result.AuthTokenIDGenerator;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.result.IAuthToken;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AuthToken
implements IAuthToken {
    private final String m_sID;
    private final IAuthIdentification m_aIdentification;
    private final LocalDateTime m_aCreationDT;
    private LocalDateTime m_aLastAccessDT;
    private final int m_nExpirationSeconds;
    private boolean m_bExpired;

    public AuthToken(@Nonnull IAuthIdentification iAuthIdentification, @Nonnegative int n) {
        ValueEnforcer.notNull(iAuthIdentification, "Identification");
        ValueEnforcer.isGE0(n, "ExpirationSeconds");
        this.m_sID = AuthTokenIDGenerator.generateNewTokenID();
        if (StringHelper.hasNoText(this.m_sID)) {
            throw new IllegalStateException("Failed to create token ID");
        }
        this.m_aIdentification = iAuthIdentification;
        this.m_aLastAccessDT = this.m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
        this.m_nExpirationSeconds = n;
        this.m_bExpired = false;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public IAuthIdentification getIdentification() {
        return this.m_aIdentification;
    }

    @Override
    @Nonnull
    public LocalDateTime getCreationDate() {
        return this.m_aCreationDT;
    }

    @Override
    @Nonnull
    public LocalDateTime getLastAccessDate() {
        return this.m_aLastAccessDT;
    }

    @Override
    @Nonnegative
    public int getExpirationSeconds() {
        return this.m_nExpirationSeconds;
    }

    @Override
    public boolean isExpirationPossible() {
        return this.m_nExpirationSeconds > 0;
    }

    @Override
    @Nullable
    public LocalDateTime getExpirationDate() {
        return this.isExpirationPossible() ? this.m_aLastAccessDT.plusSeconds(this.m_nExpirationSeconds) : null;
    }

    @Override
    public boolean isExpired() {
        if (!this.m_bExpired && this.isExpirationPossible() && Duration.between(this.m_aLastAccessDT, PDTFactory.getCurrentLocalDateTime()).getSeconds() > (long)this.m_nExpirationSeconds) {
            this.m_bExpired = true;
        }
        return this.m_bExpired;
    }

    void setExpired() {
        this.m_bExpired = true;
    }

    void updateLastAccess() {
        this.m_aLastAccessDT = PDTFactory.getCurrentLocalDateTime();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AuthToken authToken = (AuthToken)object;
        return this.m_sID.equals(authToken.m_sID) && this.m_aIdentification.equals(authToken.m_aIdentification) && this.m_aCreationDT.equals(authToken.m_aCreationDT) && this.m_aLastAccessDT.equals(authToken.m_aLastAccessDT) && this.m_bExpired == authToken.m_bExpired && this.m_nExpirationSeconds == authToken.m_nExpirationSeconds;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_aIdentification).append(this.m_aCreationDT).append(this.m_aLastAccessDT).append(this.m_bExpired).append(this.m_nExpirationSeconds).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("id", this.m_sID).append("identification", this.m_aIdentification).append("creationDT", this.m_aCreationDT).append("lastAccessDT", this.m_aLastAccessDT).append("expired", this.m_bExpired).append("expirationSeconds", this.m_nExpirationSeconds).getToString();
    }
}

