/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronProviderXSLTFromSCH;
import com.helger.xml.serialize.write.XMLWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SchematronResourceSCHCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronResourceSCHCache.class);
    private static final Lock s_aLock = new ReentrantLock();
    private static final ICommonsMap<String, SchematronProviderXSLTFromSCH> s_aCache = new CommonsHashMap<String, SchematronProviderXSLTFromSCH>();

    private SchematronResourceSCHCache() {
    }

    @Nullable
    public static SchematronProviderXSLTFromSCH createSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiling Schematron instance " + iReadableResource.toString());
        }
        if (!(schematronProviderXSLTFromSCH = new SchematronProviderXSLTFromSCH(iReadableResource, sCHTransformerCustomizer)).isValidSchematron()) {
            LOGGER.warn("The Schematron resource '" + iReadableResource.getResourceID() + "' is invalid!");
            if (LOGGER.isDebugEnabled() && schematronProviderXSLTFromSCH.getXSLTDocument() != null) {
                LOGGER.debug("  Created XSLT document:\n" + XMLWriter.getNodeAsString(schematronProviderXSLTFromSCH.getXSLTDocument()));
            }
            return null;
        }
        if (schematronProviderXSLTFromSCH.getXSLTDocument() == null) {
            throw new IllegalStateException("No XSLT document retrieved from Schematron resource '" + iReadableResource.getResourceID() + "'!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished compiling Schematron instance " + iReadableResource.toString());
        }
        return schematronProviderXSLTFromSCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SchematronProviderXSLTFromSCH getSchematronXSLTProvider(@Nonnull IReadableResource iReadableResource, @Nonnull SCHTransformerCustomizer sCHTransformerCustomizer) {
        ValueEnforcer.notNull(iReadableResource, "SchematronResource");
        ValueEnforcer.notNull(sCHTransformerCustomizer, "TransformerCustomizer");
        if (!iReadableResource.exists()) {
            LOGGER.warn("Schematron resource " + iReadableResource + " does not exist!");
            return null;
        }
        if (!sCHTransformerCustomizer.canCacheResult()) {
            return SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer);
        }
        String string = StringHelper.getImploded(':', new String[]{iReadableResource.getResourceID(), StringHelper.getNotNull(sCHTransformerCustomizer.getPhase()), StringHelper.getNotNull(sCHTransformerCustomizer.getLanguageCode())});
        s_aLock.lock();
        try {
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = (SchematronProviderXSLTFromSCH)s_aCache.get(string);
            if (schematronProviderXSLTFromSCH == null && (schematronProviderXSLTFromSCH = SchematronResourceSCHCache.createSchematronXSLTProvider(iReadableResource, sCHTransformerCustomizer)) != null) {
                s_aCache.put(string, schematronProviderXSLTFromSCH);
            }
            SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH2 = schematronProviderXSLTFromSCH;
            return schematronProviderXSLTFromSCH2;
        }
        finally {
            s_aLock.unlock();
        }
    }
}

