/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.xml.transform.LoggingTransformErrorListener;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;

@NotThreadSafe
public class SCHTransformerCustomizer {
    public static final boolean DEFAULT_FORCE_CACHE_RESULT = false;
    private ErrorListener m_aCustomErrorListener;
    private URIResolver m_aCustomURIResolver;
    private ICommonsOrderedMap<String, Object> m_aCustomParameters;
    private String m_sPhase;
    private String m_sLanguageCode;
    private boolean m_bForceCacheResult = false;

    @Nullable
    public ErrorListener getErrorListener() {
        return this.m_aCustomErrorListener;
    }

    @Nonnull
    public SCHTransformerCustomizer setErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aCustomErrorListener = errorListener;
        return this;
    }

    @Nullable
    public URIResolver getURIResolver() {
        return this.m_aCustomURIResolver;
    }

    @Nonnull
    public SCHTransformerCustomizer setURIResolver(@Nullable URIResolver uRIResolver) {
        this.m_aCustomURIResolver = uRIResolver;
        return this;
    }

    public boolean hasParameters() {
        return this.m_aCustomParameters != null && this.m_aCustomParameters.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ?> getParameters() {
        return new CommonsLinkedHashMap<String, Object>((Map<String, Object>)this.m_aCustomParameters);
    }

    @Nonnull
    public SCHTransformerCustomizer setParameters(@Nullable Map<String, ?> map) {
        this.m_aCustomParameters = new CommonsLinkedHashMap(map);
        return this;
    }

    @Nullable
    public String getPhase() {
        return this.m_sPhase;
    }

    @Nonnull
    public SCHTransformerCustomizer setPhase(@Nullable String string) {
        this.m_sPhase = string;
        return this;
    }

    @Nullable
    public String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    @Nonnull
    public SCHTransformerCustomizer setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
        return this;
    }

    public boolean isForceCacheResult() {
        return this.m_bForceCacheResult;
    }

    @Nonnull
    public SCHTransformerCustomizer setForceCacheResult(boolean bl) {
        this.m_bForceCacheResult = bl;
        return this;
    }

    public boolean canCacheResult() {
        return !this.hasParameters() || this.m_bForceCacheResult;
    }

    public void customize(@Nonnull TransformerFactory transformerFactory) {
        if (this.m_aCustomErrorListener != null) {
            transformerFactory.setErrorListener(this.m_aCustomErrorListener);
        } else {
            transformerFactory.setErrorListener(new LoggingTransformErrorListener(Locale.US));
        }
        if (this.m_aCustomURIResolver != null) {
            transformerFactory.setURIResolver(this.m_aCustomURIResolver);
        }
    }

    public void customize(@Nonnull EStep eStep, @Nonnull Transformer transformer) {
        if (this.m_aCustomErrorListener != null) {
            transformer.setErrorListener(this.m_aCustomErrorListener);
        } else {
            transformer.setErrorListener(new LoggingTransformErrorListener(Locale.US));
        }
        if (this.m_aCustomURIResolver != null) {
            transformer.setURIResolver(this.m_aCustomURIResolver);
        }
        if (this.m_aCustomParameters != null) {
            for (Map.Entry entry : this.m_aCustomParameters.entrySet()) {
                transformer.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        if (eStep == EStep.SCH2XSLT_3) {
            if (this.m_sPhase != null) {
                transformer.setParameter("phase", this.m_sPhase);
            }
            if (this.m_sLanguageCode != null) {
                transformer.setParameter("langCode", this.m_sLanguageCode);
            }
        }
    }

    public static enum EStep {
        SCH2XSLT_1,
        SCH2XSLT_2,
        SCH2XSLT_3;

    }
}

