/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.iterate.IterableIterator;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.schematron.xpath.XPathFunctionFromUserFunction;
import com.helger.xml.xpath.MapBasedXPathFunctionResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;

public class XQueryAsXPathFunctionConverter {
    private final String m_sBaseURL;

    public XQueryAsXPathFunctionConverter() throws MalformedURLException {
        this(new File(""));
    }

    public XQueryAsXPathFunctionConverter(@Nonnull File file) throws MalformedURLException {
        this(FileHelper.getAsURLString(file));
    }

    public XQueryAsXPathFunctionConverter(@Nonnull @Nonempty String string) {
        this.m_sBaseURL = ValueEnforcer.notEmpty(string, "BaseURL");
    }

    @Nonnull
    @Nonempty
    public String getBaseURL() {
        return this.m_sBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MapBasedXPathFunctionResolver loadXQuery(@Nonnull @WillClose InputStream inputStream) throws XPathException, IOException {
        ValueEnforcer.notNull(inputStream, "XQueryIS");
        try {
            MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = new MapBasedXPathFunctionResolver();
            Configuration configuration = new Configuration();
            DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(configuration);
            StaticQueryContext staticQueryContext = configuration.newStaticQueryContext();
            staticQueryContext.setBaseURI(this.m_sBaseURL);
            String string = null;
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(inputStream, string);
            Controller controller = xQueryExpression.newController(dynamicQueryContext);
            FunctionLibraryList functionLibraryList = xQueryExpression.getExecutable().getFunctionLibrary();
            for (FunctionLibrary functionLibrary : functionLibraryList.getLibraryList()) {
                XQueryFunctionBinder xQueryFunctionBinder;
                if (functionLibrary instanceof FunctionLibraryList) {
                    xQueryFunctionBinder = (FunctionLibraryList)functionLibrary;
                    for (FunctionLibrary functionLibrary2 : ((FunctionLibraryList)xQueryFunctionBinder).getLibraryList()) {
                        if (!(functionLibrary2 instanceof ExecutableFunctionLibrary)) continue;
                        for (UserFunction userFunction : new IterableIterator<UserFunction>(((ExecutableFunctionLibrary)functionLibrary2).iterateFunctions())) {
                            mapBasedXPathFunctionResolver.addUniqueFunction(userFunction.getFunctionName().getNamespaceBinding().getURI(), userFunction.getFunctionName().getLocalPart(), userFunction.getArity(), new XPathFunctionFromUserFunction(configuration, controller, userFunction));
                        }
                    }
                    continue;
                }
                if (!(functionLibrary instanceof XQueryFunctionLibrary)) continue;
                xQueryFunctionBinder = (XQueryFunctionLibrary)functionLibrary;
                for (XQueryFunction xQueryFunction : new IterableIterator<XQueryFunction>(((XQueryFunctionLibrary)xQueryFunctionBinder).getFunctionDefinitions())) {
                    xQueryFunction.compile();
                    mapBasedXPathFunctionResolver.addUniqueFunction(xQueryFunction.getFunctionName().getNamespaceBinding().getURI(), xQueryFunction.getFunctionName().getLocalPart(), xQueryFunction.getNumberOfArguments(), new XPathFunctionFromUserFunction(configuration, controller, xQueryFunction.getUserFunction()));
                }
            }
            MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver2 = mapBasedXPathFunctionResolver;
            return mapBasedXPathFunctionResolver2;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }
}

