/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.xpath.IXPathConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

@Immutable
public class XPathConfig
implements IXPathConfig {
    private final XPathFactory m_aXPathFactory;
    private final XPathVariableResolver m_aXPathVariableResolver;
    private final XPathFunctionResolver m_aXPathFunctionResolver;

    public XPathConfig(@Nonnull XPathFactory xPathFactory, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver) {
        ValueEnforcer.notNull(xPathFactory, "XPathFactory");
        this.m_aXPathFactory = xPathFactory;
        this.m_aXPathVariableResolver = xPathVariableResolver;
        this.m_aXPathFunctionResolver = xPathFunctionResolver;
    }

    @Override
    @Nonnull
    public XPathFactory getXPathFactory() {
        return this.m_aXPathFactory;
    }

    @Override
    @Nullable
    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_aXPathVariableResolver;
    }

    @Override
    @Nullable
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_aXPathFunctionResolver;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XPathConfig xPathConfig = (XPathConfig)object;
        return this.m_aXPathFactory.equals(xPathConfig.m_aXPathFactory) && EqualsHelper.equals(this.m_aXPathVariableResolver, xPathConfig.m_aXPathVariableResolver) && EqualsHelper.equals(this.m_aXPathFunctionResolver, xPathConfig.m_aXPathFunctionResolver);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aXPathFactory).append(this.m_aXPathVariableResolver).append(this.m_aXPathFunctionResolver).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("XPathFactory", this.m_aXPathFactory).append("XPathVariableResolver", this.m_aXPathVariableResolver).append("XPathFunctionResolver", this.m_aXPathFunctionResolver).getToString();
    }
}

