/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.text.IHasErrorText;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.location.ILocation;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SVRLResourceError
extends SingleError {
    private final String m_sTest;

    public SVRLResourceError(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable, @Nonnull String string3) {
        super(iErrorLevel, string, string2, iLocation, iHasErrorText, throwable);
        this.m_sTest = ValueEnforcer.notNull(string3, "Test");
    }

    @Nonnull
    public String getTest() {
        return this.m_sTest;
    }

    @Override
    public String getAsString(@Nonnull Locale locale) {
        String string = super.getAsString(locale);
        string = string + " Test=" + this.m_sTest;
        return string;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        SVRLResourceError sVRLResourceError = (SVRLResourceError)object;
        return this.m_sTest.equals(sVRLResourceError.m_sTest);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sTest).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("test", this.m_sTest).getToString();
    }

    public static class SVRLErrorBuilder
    extends SingleError.AbstractBuilder<SVRLResourceError, SVRLErrorBuilder> {
        private String m_sTest;

        public SVRLErrorBuilder(@Nonnull String string) {
            this.setTest(string);
        }

        @Nonnull
        public final SVRLErrorBuilder setTest(@Nonnull String string) {
            this.m_sTest = ValueEnforcer.notNull(string, "Test");
            return this;
        }

        @Override
        public SVRLResourceError build() {
            return new SVRLResourceError(this.m_aErrorLevel, this.m_sErrorID, this.m_sErrorFieldName, this.m_aErrorLocation, this.m_aErrorText, this.m_aLinkedException, this.m_sTest);
        }
    }
}

