/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSDiagnostics;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSNS;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSTitle;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSSchema
implements IPSElement,
IPSHasID,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasRichGroup {
    private final IReadableResource m_aResource;
    private String m_sID;
    private PSRichGroup m_aRich;
    private String m_sSchemaVersion;
    private String m_sDefaultPhase;
    private String m_sQueryBinding;
    private PSTitle m_aTitle;
    private final ICommonsList<PSInclude> m_aIncludes = new CommonsArrayList<PSInclude>();
    private final ICommonsList<PSNS> m_aNSs = new CommonsArrayList<PSNS>();
    private final ICommonsList<PSP> m_aStartPs = new CommonsArrayList<PSP>();
    private final ICommonsList<PSLet> m_aLets = new CommonsArrayList<PSLet>();
    private final ICommonsList<PSPhase> m_aPhases = new CommonsArrayList<PSPhase>();
    private final ICommonsList<PSPattern> m_aPatterns = new CommonsArrayList<PSPattern>();
    private final ICommonsList<PSP> m_aEndPs = new CommonsArrayList<PSP>();
    private PSDiagnostics m_aDiagnostics;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;
    private ICommonsList<IMicroElement> m_aForeignElements;

    public PSSchema() {
        this(null);
    }

    public PSSchema(@Nullable IReadableResource iReadableResource) {
        this.m_aResource = iReadableResource;
    }

    @Nullable
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aPatterns.isEmpty()) {
            iPSErrorHandler.error(this, "<schema> has no <pattern>s");
            return false;
        }
        if (this.m_aTitle != null && !this.m_aTitle.isValid(iPSErrorHandler)) {
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSNS pSNS : this.m_aNSs) {
            if (pSNS.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSP pSP : this.m_aStartPs) {
            if (pSP.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            if (pSPhase.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isValid(iPSErrorHandler)) continue;
            return false;
        }
        for (PSP pSP : this.m_aEndPs) {
            if (pSP.isValid(iPSErrorHandler)) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isValid(iPSErrorHandler);
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (this.m_aPatterns.isEmpty()) {
            iPSErrorHandler.error(this, "<schema> has no <pattern>s");
        }
        if (this.m_aTitle != null) {
            this.m_aTitle.validateCompletely(iPSErrorHandler);
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            iPSElement.validateCompletely(iPSErrorHandler);
        }
        for (PSNS pSNS : this.m_aNSs) {
            pSNS.validateCompletely(iPSErrorHandler);
        }
        for (PSP pSP : this.m_aStartPs) {
            pSP.validateCompletely(iPSErrorHandler);
        }
        for (PSLet pSLet : this.m_aLets) {
            pSLet.validateCompletely(iPSErrorHandler);
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            pSPhase.validateCompletely(iPSErrorHandler);
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            pSPattern.validateCompletely(iPSErrorHandler);
        }
        for (PSP pSP : this.m_aEndPs) {
            pSP.validateCompletely(iPSErrorHandler);
        }
        if (this.m_aDiagnostics != null) {
            this.m_aDiagnostics.validateCompletely(iPSErrorHandler);
        }
    }

    public boolean isPreprocessed() {
        if (this.hasAnyInclude()) {
            return false;
        }
        for (PSPhase iPSHasIncludes : this.m_aPhases) {
            if (!iPSHasIncludes.hasAnyInclude()) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isAbstract() || pSPattern.hasAnyInclude() || pSPattern.hasAnyParam()) {
                return false;
            }
            for (PSRule pSRule : pSPattern.getAllRules()) {
                if (!pSRule.isAbstract() && !pSRule.hasAnyInclude() && !pSRule.hasAnyExtends()) continue;
                return false;
            }
        }
        return this.m_aDiagnostics == null || !this.m_aDiagnostics.hasAnyInclude();
    }

    @Override
    public boolean isMinimal() {
        if (this.m_aTitle != null && !this.m_aTitle.isMinimal()) {
            return false;
        }
        for (PSInclude iPSElement : this.m_aIncludes) {
            if (iPSElement.isMinimal()) continue;
            return false;
        }
        for (PSNS pSNS : this.m_aNSs) {
            if (pSNS.isMinimal()) continue;
            return false;
        }
        for (PSP pSP : this.m_aStartPs) {
            if (pSP.isMinimal()) continue;
            return false;
        }
        for (PSLet pSLet : this.m_aLets) {
            if (pSLet.isMinimal()) continue;
            return false;
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            if (pSPhase.isMinimal()) continue;
            return false;
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            if (pSPattern.isMinimal()) continue;
            return false;
        }
        for (PSP pSP : this.m_aEndPs) {
            if (pSP.isMinimal()) continue;
            return false;
        }
        return this.m_aDiagnostics == null || this.m_aDiagnostics.isMinimal();
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull(iMicroElement, "ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new CommonsArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && this.m_aForeignElements.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return new CommonsArrayList<ICommonsList<IMicroElement>>(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    public void setQueryBinding(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("queryBinding may not be empty!");
        }
        this.m_sQueryBinding = string;
    }

    @Nullable
    public String getQueryBinding() {
        return this.m_sQueryBinding;
    }

    public void setSchemaVersion(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("schemaVersion may not be empty!");
        }
        this.m_sSchemaVersion = string;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.m_sSchemaVersion;
    }

    public void setDefaultPhase(@Nullable String string) {
        this.m_sDefaultPhase = string;
    }

    @Nullable
    public String getDefaultPhase() {
        return this.m_sDefaultPhase;
    }

    public void setTitle(@Nullable PSTitle pSTitle) {
        this.m_aTitle = pSTitle;
    }

    @Nullable
    public PSTitle getTitle() {
        return this.m_aTitle;
    }

    public boolean hasTitle() {
        return this.m_aTitle != null;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull(pSInclude, "Include");
        this.m_aIncludes.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aIncludes.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return (ICommonsList)this.m_aIncludes.getClone();
    }

    public void addNS(@Nonnull PSNS pSNS) {
        ValueEnforcer.notNull(pSNS, "NS");
        this.m_aNSs.add(pSNS);
    }

    public boolean hasAnyNS() {
        return this.m_aNSs.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSNS> getAllNSs() {
        return (ICommonsList)this.m_aNSs.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapBasedNamespaceContext getAsNamespaceContext() {
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        for (PSNS pSNS : this.m_aNSs) {
            mapBasedNamespaceContext.addMapping(pSNS.getPrefix(), pSNS.getUri());
        }
        return mapBasedNamespaceContext;
    }

    public void addStartP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull(pSP, "P");
        this.m_aStartPs.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllStartPs() {
        return (ICommonsList)this.m_aStartPs.getClone();
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull(pSLet, "Let");
        this.m_aLets.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aLets.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return (ICommonsList)this.m_aLets.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (PSLet pSLet : this.m_aLets) {
            commonsLinkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    public void addPhase(@Nonnull PSPhase pSPhase) {
        ValueEnforcer.notNull(pSPhase, "Phase");
        this.m_aPhases.add(pSPhase);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSPhase> getAllPhases() {
        return (ICommonsList)this.m_aPhases.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllPhaseIDs() {
        return this.m_aPhases.getAllMapped(IPSHasID::hasID, PSPhase::getID);
    }

    @Nullable
    public PSPhase getPhaseOfID(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (PSPhase pSPhase : this.m_aPhases) {
                if (!string.equals(pSPhase.getID())) continue;
                return pSPhase;
            }
        }
        return null;
    }

    public void addPattern(@Nonnull PSPattern pSPattern) {
        ValueEnforcer.notNull(pSPattern, "Pattern");
        this.m_aPatterns.add(pSPattern);
    }

    public boolean hasPatterns() {
        return this.m_aPatterns.isNotEmpty();
    }

    public boolean hasNoPatterns() {
        return this.m_aPatterns.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSPattern> getAllPatterns() {
        return (ICommonsList)this.m_aPatterns.getClone();
    }

    @Nonnegative
    public int getPatternCount() {
        return this.m_aPatterns.size();
    }

    @Nullable
    public PSPattern getPatternOfID(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (PSPattern pSPattern : this.m_aPatterns) {
                if (!string.equals(pSPattern.getID())) continue;
                return pSPattern;
            }
        }
        return null;
    }

    public void addEndP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull(pSP, "P");
        this.m_aEndPs.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllEndPs() {
        return (ICommonsList)this.m_aEndPs.getClone();
    }

    public void setDiagnostics(@Nullable PSDiagnostics pSDiagnostics) {
        this.m_aDiagnostics = pSDiagnostics;
    }

    public boolean hasDiagnostics() {
        return this.m_aDiagnostics != null;
    }

    @Nullable
    public PSDiagnostics getDiagnostics() {
        return this.m_aDiagnostics;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "schema");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement(microElement);
        }
        microElement.setAttribute("schemaVersion", this.m_sSchemaVersion);
        microElement.setAttribute("defaultPhase", this.m_sDefaultPhase);
        microElement.setAttribute("queryBinding", this.m_sQueryBinding);
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild(object.getClone());
            }
        }
        for (PSInclude pSInclude : this.m_aIncludes) {
            microElement.appendChild(pSInclude.getAsMicroElement());
        }
        if (this.m_aTitle != null) {
            microElement.appendChild(this.m_aTitle.getAsMicroElement());
        }
        for (PSNS pSNS : this.m_aNSs) {
            microElement.appendChild(pSNS.getAsMicroElement());
        }
        for (PSP pSP : this.m_aStartPs) {
            microElement.appendChild(pSP.getAsMicroElement());
        }
        for (PSLet pSLet : this.m_aLets) {
            microElement.appendChild(pSLet.getAsMicroElement());
        }
        for (PSPhase pSPhase : this.m_aPhases) {
            microElement.appendChild(pSPhase.getAsMicroElement());
        }
        for (PSPattern pSPattern : this.m_aPatterns) {
            microElement.appendChild(pSPattern.getAsMicroElement());
        }
        for (PSP pSP : this.m_aEndPs) {
            microElement.appendChild(pSP.getAsMicroElement());
        }
        if (this.m_aDiagnostics != null) {
            microElement.appendChild(this.m_aDiagnostics.getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("resource", this.m_aResource).appendIfNotNull("id", this.m_sID).appendIfNotNull("rich", this.m_aRich).appendIfNotNull("schemaVersion", this.m_sSchemaVersion).appendIfNotNull("defaultPhase", this.m_sDefaultPhase).appendIfNotNull("queryBinding", this.m_sQueryBinding).appendIfNotNull("title", this.m_aTitle).appendIf("includes", this.m_aIncludes, CollectionHelper::isNotEmpty).appendIf("nss", this.m_aNSs, CollectionHelper::isNotEmpty).appendIf("startps", this.m_aStartPs, CollectionHelper::isNotEmpty).appendIf("lets", this.m_aLets, CollectionHelper::isNotEmpty).appendIf("phases", this.m_aPhases, CollectionHelper::isNotEmpty).appendIf("patterns", this.m_aPatterns, CollectionHelper::isNotEmpty).appendIf("endps", this.m_aEndPs, CollectionHelper::isNotEmpty).appendIfNotNull("diagnostics", this.m_aDiagnostics).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).appendIf("foreignElements", this.m_aForeignElements, CollectionHelper::isNotEmpty).getToString();
    }
}

