/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasID;
import com.helger.schematron.pure.model.IPSHasIncludes;
import com.helger.schematron.pure.model.IPSHasLets;
import com.helger.schematron.pure.model.IPSHasRichGroup;
import com.helger.schematron.pure.model.PSActive;
import com.helger.schematron.pure.model.PSInclude;
import com.helger.schematron.pure.model.PSLet;
import com.helger.schematron.pure.model.PSP;
import com.helger.schematron.pure.model.PSRichGroup;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSPhase
implements IPSElement,
IPSHasForeignElements,
IPSHasIncludes,
IPSHasLets,
IPSHasID,
IPSHasRichGroup {
    private String m_sID;
    private PSRichGroup m_aRich;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList<Object>();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (StringHelper.hasNoText(this.m_sID)) {
            iPSErrorHandler.error(this, "<phase> has no 'id'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
        if (StringHelper.hasNoText(this.m_sID)) {
            iPSErrorHandler.error(this, "<phase> has no 'id'");
        }
    }

    @Override
    public boolean isMinimal() {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull(iMicroElement, "ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add(iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    public void addInclude(@Nonnull PSInclude pSInclude) {
        ValueEnforcer.notNull(pSInclude, "Include");
        this.m_aContent.add(pSInclude);
    }

    @Override
    public boolean hasAnyInclude() {
        return this.m_aContent.containsAny(object -> object instanceof PSInclude);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSInclude> getAllIncludes() {
        return this.m_aContent.getAllInstanceOf(PSInclude.class);
    }

    public void addP(@Nonnull PSP pSP) {
        ValueEnforcer.notNull(pSP, "P");
        this.m_aContent.add(pSP);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSP> getAllPs() {
        return this.m_aContent.getAllInstanceOf(PSP.class);
    }

    @Override
    public void addLet(@Nonnull PSLet pSLet) {
        ValueEnforcer.notNull(pSLet, "Let");
        this.m_aContent.add(pSLet);
    }

    @Override
    public boolean hasAnyLet() {
        return this.m_aContent.containsAny(object -> object instanceof PSLet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSLet> getAllLets() {
        return this.m_aContent.getAllInstanceOf(PSLet.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllLetsAsMap() {
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (Object e : this.m_aContent) {
            if (!(e instanceof PSLet)) continue;
            PSLet pSLet = (PSLet)e;
            commonsLinkedHashMap.put(pSLet.getName(), pSLet.getValue());
        }
        return commonsLinkedHashMap;
    }

    public void addActive(@Nonnull PSActive pSActive) {
        ValueEnforcer.notNull(pSActive, "Active");
        this.m_aContent.add(pSActive);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSActive> getAllActives() {
        return this.m_aContent.getAllInstanceOf(PSActive.class);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IPSElement> getAllContentElements() {
        return this.m_aContent.getAllMapped(object -> object instanceof IPSElement && !(object instanceof PSInclude), object -> (IPSElement)object);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "phase");
        microElement.setAttribute("id", this.m_sID);
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement(microElement);
        }
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild(((IMicroElement)object).getClone());
                continue;
            }
            microElement.appendChild(((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("id", this.m_sID).appendIfNotNull("rich", this.m_aRich).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

