/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSHasForeignAttributes;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSNS
implements IPSClonableElement<PSNS>,
IPSHasForeignAttributes {
    private String m_sUri;
    private String m_sPrefix;
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText(this.m_sUri)) {
            iPSErrorHandler.error(this, "<ns> has no 'uri'");
            return false;
        }
        if (StringHelper.hasNoText(this.m_sPrefix)) {
            iPSErrorHandler.error(this, "<ns> has no 'prefix'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        if (StringHelper.hasNoText(this.m_sUri)) {
            iPSErrorHandler.error(this, "<ns> has no 'uri'");
        }
        if (StringHelper.hasNoText(this.m_sPrefix)) {
            iPSErrorHandler.error(this, "<ns> has no 'prefix'");
        }
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    public void setUri(@Nullable String string) {
        this.m_sUri = string;
    }

    @Nullable
    public String getUri() {
        return this.m_sUri;
    }

    public void setPrefix(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "ns");
        microElement.setAttribute("prefix", this.m_sPrefix);
        microElement.setAttribute("uri", this.m_sUri);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PSNS getClone() {
        PSNS pSNS = new PSNS();
        pSNS.setUri(this.m_sUri);
        pSNS.setPrefix(this.m_sPrefix);
        if (this.hasForeignAttributes()) {
            pSNS.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSNS;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("uri", this.m_sUri).appendIfNotNull("prefix", this.m_sPrefix).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

