/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.model;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import com.helger.schematron.pure.model.IPSClonableElement;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.schematron.pure.model.IPSHasForeignElements;
import com.helger.schematron.pure.model.IPSHasMixedContent;
import com.helger.schematron.pure.model.PSDir;
import com.helger.schematron.pure.model.PSEmph;
import com.helger.schematron.pure.model.PSSpan;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSActive
implements IPSClonableElement<PSActive>,
IPSHasForeignElements,
IPSHasMixedContent {
    private String m_sPattern;
    private final ICommonsList<Object> m_aContent = new CommonsArrayList<Object>();
    private ICommonsOrderedMap<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isValid(iPSErrorHandler)) continue;
            return false;
        }
        if (StringHelper.hasNoText(this.m_sPattern)) {
            iPSErrorHandler.error(this, "<active> has no 'pattern'");
            return false;
        }
        return true;
    }

    @Override
    public void validateCompletely(@Nonnull IPSErrorHandler iPSErrorHandler) {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement)) continue;
            ((IPSElement)e).validateCompletely(iPSErrorHandler);
        }
        if (StringHelper.hasNoText(this.m_sPattern)) {
            iPSErrorHandler.error(this, "<active> has no 'pattern'");
        }
    }

    @Override
    public boolean isMinimal() {
        for (Object e : this.m_aContent) {
            if (!(e instanceof IPSElement) || ((IPSElement)e).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull(iMicroElement, "ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        this.m_aContent.add(iMicroElement);
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aContent.containsAny(object -> object instanceof IMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMicroElement> getAllForeignElements() {
        return this.m_aContent.getAllInstanceOf(IMicroElement.class);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(string, "AttrName");
        ValueEnforcer.notNull(string2, "AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && this.m_aForeignAttrs.isNotEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllForeignAttributes() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aForeignAttrs);
    }

    public void setPattern(@Nullable String string) {
        this.m_sPattern = string;
    }

    @Nullable
    public String getPattern() {
        return this.m_sPattern;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        return this.m_aContent.containsAny(object -> object instanceof String);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTexts() {
        return this.m_aContent.getAllInstanceOf(String.class);
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull(pSDir, "Dir");
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSDir> getAllDirs() {
        return this.m_aContent.getAllInstanceOf(PSDir.class);
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        ValueEnforcer.notNull(pSEmph, "Emph");
        this.m_aContent.add(pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSEmph> getAllEmphs() {
        return this.m_aContent.getAllInstanceOf(PSEmph.class);
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull(pSSpan, "Span");
        this.m_aContent.add(pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSSpan> getAllSpans() {
        return this.m_aContent.getAllInstanceOf(PSSpan.class);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllContentElements() {
        return (ICommonsList)this.m_aContent.getClone();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "active");
        microElement.setAttribute("pattern", this.m_sPattern);
        for (Object object : this.m_aContent) {
            if (object instanceof IMicroElement) {
                microElement.appendChild(((IMicroElement)object).getClone());
                continue;
            }
            if (object instanceof String) {
                microElement.appendText((String)object);
                continue;
            }
            microElement.appendChild(((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Override
    @Nonnull
    public PSActive getClone() {
        PSActive pSActive = new PSActive();
        pSActive.setPattern(this.m_sPattern);
        for (Object e : this.m_aContent) {
            if (e instanceof String) {
                pSActive.addText((String)e);
                continue;
            }
            if (e instanceof PSDir) {
                pSActive.addDir(((PSDir)e).getClone());
                continue;
            }
            if (e instanceof PSEmph) {
                pSActive.addEmph(((PSEmph)e).getClone());
                continue;
            }
            if (e instanceof PSSpan) {
                pSActive.addSpan(((PSSpan)e).getClone());
                continue;
            }
            if (!(e instanceof IMicroElement)) continue;
            pSActive.addForeignElement(((IMicroElement)e).getClone());
        }
        if (this.hasForeignAttributes()) {
            pSActive.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSActive;
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("pattern", this.m_sPattern).appendIf("content", this.m_aContent, CollectionHelper::isNotEmpty).appendIf("foreignAttrs", this.m_aForeignAttrs, CollectionHelper::isNotEmpty).getToString();
    }
}

