/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.exchange;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.exchange.IPSWriterSettings;
import com.helger.schematron.pure.exchange.PSWriterSettings;
import com.helger.schematron.pure.model.IPSElement;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;

public class PSWriter {
    private final IPSWriterSettings m_aWriterSettings;

    public PSWriter() {
        this(PSWriterSettings.DEFAULT_SETTINGS);
    }

    public PSWriter(@Nonnull IPSWriterSettings iPSWriterSettings) {
        this.m_aWriterSettings = ValueEnforcer.notNull(iPSWriterSettings, "WriterSettings");
    }

    @Nonnull
    public IPSWriterSettings getWriterSettings() {
        return this.m_aWriterSettings;
    }

    @Nonnull
    @OverrideOnDemand
    protected IMicroNode getAsDocument(@Nonnull IMicroElement iMicroElement) {
        MicroDocument microDocument = new MicroDocument();
        microDocument.appendChild(iMicroElement);
        return microDocument;
    }

    @Nonnull
    public ESuccess writeToFile(@Nonnull IPSElement iPSElement, @Nonnull File file) {
        ValueEnforcer.notNull(iPSElement, "PSElement");
        IMicroElement iMicroElement = iPSElement.getAsMicroElement();
        return MicroWriter.writeToFile(this.getAsDocument(iMicroElement), file, this.m_aWriterSettings.getXMLWriterSettings());
    }

    @Nonnull
    public ESuccess writeToStream(@Nonnull IPSElement iPSElement, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(iPSElement, "PSElement");
        IMicroElement iMicroElement = iPSElement.getAsMicroElement();
        return MicroWriter.writeToStream(this.getAsDocument(iMicroElement), outputStream, this.m_aWriterSettings.getXMLWriterSettings());
    }

    @Nonnull
    public ESuccess writeToWriter(@Nonnull IPSElement iPSElement, @Nonnull @WillClose Writer writer) {
        ValueEnforcer.notNull(iPSElement, "PSElement");
        IMicroElement iMicroElement = iPSElement.getAsMicroElement();
        return MicroWriter.writeToWriter(this.getAsDocument(iMicroElement), writer, this.m_aWriterSettings.getXMLWriterSettings());
    }

    @Nullable
    public String getXMLString(@Nonnull IPSElement iPSElement) {
        ValueEnforcer.notNull(iPSElement, "PSElement");
        IMicroElement iMicroElement = iPSElement.getAsMicroElement();
        return MicroWriter.getNodeAsString(this.getAsDocument(iMicroElement), this.m_aWriterSettings.getXMLWriterSettings());
    }

    @Nullable
    public String getXMLStringNotNull(@Nonnull IPSElement iPSElement) {
        String string = this.getXMLString(iPSElement);
        if (string == null) {
            throw new IllegalStateException("Failed to serialize the passed PS element: " + iPSElement);
        }
        return string;
    }

    public String toString() {
        return new ToStringGenerator(this).append("writerSettings", this.m_aWriterSettings).getToString();
    }
}

