/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsNavigableMap;
import com.helger.commons.compare.IComparator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.xpath.IPSXPathVariables;
import com.helger.schematron.pure.binding.xpath.PSXPathQueryBinding;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSXPathVariables
implements IPSXPathVariables {
    private final ICommonsNavigableMap<String, String> m_aMap;

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsNavigableMap<String, String> _createMap() {
        return new CommonsTreeMap<String, String>((Comparator<String>)IComparator.getComparatorStringLongestFirst());
    }

    public PSXPathVariables() {
        this.m_aMap = PSXPathVariables._createMap();
    }

    public PSXPathVariables(@Nonnull IPSXPathVariables iPSXPathVariables) {
        this.m_aMap = iPSXPathVariables.getAll();
    }

    @Nonnull
    public EChange add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public EChange add(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notEmpty(string2, "Value");
        String string3 = '$' + string;
        if (this.m_aMap.containsKey(string3)) {
            return EChange.UNCHANGED;
        }
        String string4 = this.getAppliedReplacement(string2);
        this.m_aMap.put(string3, string4);
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getAppliedReplacement(@Nullable String string) {
        return PSXPathQueryBinding.getWithParamTextsReplacedStatic(string, this.m_aMap);
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        if (StringHelper.hasText(string) && this.m_aMap.remove('$' + string) == null) {
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeAll(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or(this.remove(string));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsNavigableMap<String, String> getAll() {
        return this.m_aMap.getClone();
    }

    @Override
    public boolean contains(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.m_aMap.containsKey(string);
    }

    @Override
    @Nullable
    public String get(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return (String)this.m_aMap.get(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PSXPathVariables getClone() {
        return new PSXPathVariables(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

