/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.process;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.peppolid.peppol.process.EPredefinedProcessIdentifier;
import com.helger.peppolid.peppol.process.IPeppolPredefinedProcessIdentifier;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedProcessIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedProcessIdentifier> s_aCodes = new CommonsHashMap<String, IPeppolPredefinedProcessIdentifier>();
    private static final PredefinedProcessIdentifierManager s_aInstance;

    private PredefinedProcessIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedProcessIdentifier> getAllProcessIdentifiers() {
        return s_aCodes.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllProcessIdentifierIDs() {
        return s_aCodes.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedProcessIdentifier getProcessIdentifierOfID(@Nullable String string) {
        if (string != null) {
            for (Map.Entry entry : s_aCodes.entrySet()) {
                if (!string.equals(entry.getKey())) continue;
                return (IPeppolPredefinedProcessIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsProcessIdentifierWithID(@Nullable String string) {
        return PredefinedProcessIdentifierManager.getProcessIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
            s_aCodes.put(ePredefinedProcessIdentifier.getValue(), ePredefinedProcessIdentifier);
        }
        s_aInstance = new PredefinedProcessIdentifierManager();
    }
}

