/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.peppolid.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolPredefinedDocumentTypeIdentifier;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedDocumentTypeIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedDocumentTypeIdentifier> s_aCodes = new CommonsHashMap<String, IPeppolPredefinedDocumentTypeIdentifier>();
    private static final PredefinedDocumentTypeIdentifierManager s_aInstance;

    private PredefinedDocumentTypeIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedDocumentTypeIdentifier> getAllDocumentTypeIdentifiers() {
        return s_aCodes.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllDocumentTypeIdentifierIDs() {
        return s_aCodes.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedDocumentTypeIdentifier getDocumentTypeIdentifierOfID(@Nullable String string) {
        if (string != null) {
            for (Map.Entry entry : s_aCodes.entrySet()) {
                if (!string.equals(entry.getKey())) continue;
                return (IPeppolPredefinedDocumentTypeIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsDocumentTypeIdentifierWithID(@Nullable String string) {
        return PredefinedDocumentTypeIdentifierManager.getDocumentTypeIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier : EPredefinedDocumentTypeIdentifier.values()) {
            s_aCodes.put(ePredefinedDocumentTypeIdentifier.getValue(), ePredefinedDocumentTypeIdentifier);
        }
        s_aInstance = new PredefinedDocumentTypeIdentifierManager();
    }
}

