/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.peppol.PeppolIdentifierHelper;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifier;
import com.helger.peppolid.peppol.participant.PeppolParticipantIdentifier;
import com.helger.peppolid.peppol.process.PeppolProcessIdentifier;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PeppolIdentifierFactory
implements IIdentifierFactory {
    public static final PeppolIdentifierFactory INSTANCE = new PeppolIdentifierFactory();

    @Override
    public boolean isDocumentTypeIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    @Nonnull
    public String getDefaultDocumentTypeIdentifierScheme() {
        return "busdox-docid-qns";
    }

    @Override
    public boolean isDocumentTypeIdentifierSchemeValid(@Nullable String string) {
        return PeppolIdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isDocumentTypeIdentifierValueValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0 || n > 500) {
            return false;
        }
        return PeppolIdentifierHelper.areCharsetChecksDisabled() || StandardCharsets.ISO_8859_1.newEncoder().canEncode(string);
    }

    @Override
    @Nullable
    public PeppolDocumentTypeIdentifier createDocumentTypeIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createDocumentTypeIdentifier(this.getDefaultDocumentTypeIdentifierScheme(), string);
    }

    @Override
    @Nullable
    public PeppolDocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isDocumentTypeIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolDocumentTypeIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    public boolean isParticipantIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    @Nonnull
    public String getDefaultParticipantIdentifierScheme() {
        return "iso6523-actorid-upis";
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    public boolean isParticipantIdentifierSchemeValid(@Nullable String string) {
        if (!PeppolIdentifierHelper.isValidIdentifierScheme(string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern("[a-z0-9]+-[a-z0-9]+-[a-z0-9]+", string.toLowerCase(Locale.US));
    }

    @Override
    public boolean isParticipantIdentifierValueValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0 || n > 50) {
            return false;
        }
        return PeppolIdentifierHelper.areCharsetChecksDisabled() || StandardCharsets.US_ASCII.newEncoder().canEncode(string);
    }

    @Override
    @Nullable
    public PeppolParticipantIdentifier createParticipantIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createParticipantIdentifier(this.getDefaultParticipantIdentifierScheme(), string);
    }

    @Override
    @Nullable
    public PeppolParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isParticipantIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolParticipantIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    @Override
    @Nonnull
    public String getDefaultProcessIdentifierScheme() {
        return "cenbii-procid-ubl";
    }

    @Override
    public boolean isProcessIdentifierSchemeValid(@Nullable String string) {
        return PeppolIdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isProcessIdentifierValueValid(@Nullable String string) {
        int n = StringHelper.getLength(string);
        if (n == 0 || n > 200) {
            return false;
        }
        return PeppolIdentifierHelper.areCharsetChecksDisabled() || StandardCharsets.ISO_8859_1.newEncoder().canEncode(string);
    }

    @Override
    @Nullable
    public PeppolProcessIdentifier createProcessIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createProcessIdentifier(this.getDefaultProcessIdentifierScheme(), string);
    }

    @Override
    @Nullable
    public PeppolProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.isProcessIdentifierCaseInsensitive(string) ? this.getUnifiedValue(string2) : string2;
        return PeppolProcessIdentifier.createIfValid(this.nullNotEmpty(string), this.nullNotEmpty(string3));
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

