/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.codelists;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.codelists.PCLProcessType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessesType", propOrder={"process"})
@CodingStyleguideUnaware
public class PCLProcessesType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(required=true)
    private List<PCLProcessType> process;
    @XmlAttribute(name="version", required=true)
    private String version;
    @XmlAttribute(name="entry-count", required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    private BigInteger entryCount;

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PCLProcessType> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<PCLProcessType>();
        }
        return this.process;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String string) {
        this.version = string;
    }

    @Nullable
    public BigInteger getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(@Nullable BigInteger bigInteger) {
        this.entryCount = bigInteger;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PCLProcessesType pCLProcessesType = (PCLProcessesType)object;
        if (!EqualsHelper.equals(this.entryCount, pCLProcessesType.entryCount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.process, pCLProcessesType.process)) {
            return false;
        }
        return EqualsHelper.equals(this.version, pCLProcessesType.version);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.entryCount).append(this.process)).append(this.version).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("entryCount", this.entryCount).append("process", this.process).append("version", this.version).getToString();
    }

    public void setProcess(@Nullable List<PCLProcessType> list) {
        this.process = list;
    }

    public boolean hasProcessEntries() {
        return !this.getProcess().isEmpty();
    }

    public boolean hasNoProcessEntries() {
        return this.getProcess().isEmpty();
    }

    @Nonnegative
    public int getProcessCount() {
        return this.getProcess().size();
    }

    @Nullable
    public PCLProcessType getProcessAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getProcess().get(n);
    }

    public void addProcess(@Nonnull PCLProcessType pCLProcessType) {
        this.getProcess().add(pCLProcessType);
    }

    public void cloneTo(@Nonnull PCLProcessesType pCLProcessesType) {
        pCLProcessesType.entryCount = this.entryCount;
        if (this.process == null) {
            pCLProcessesType.process = null;
        } else {
            ArrayList<PCLProcessType> arrayList = new ArrayList<PCLProcessType>();
            for (PCLProcessType pCLProcessType : this.getProcess()) {
                arrayList.add(pCLProcessType == null ? null : pCLProcessType.clone());
            }
            pCLProcessesType.process = arrayList;
        }
        pCLProcessesType.version = this.version;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PCLProcessesType clone() {
        PCLProcessesType pCLProcessesType = new PCLProcessesType();
        this.cloneTo(pCLProcessesType);
        return pCLProcessesType;
    }
}

