/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.functional.IFunction;
import com.helger.commons.state.ETriState;
import com.helger.commons.timing.StopWatch;
import com.helger.peppol.utils.EPeppolCertificateCheckResult;
import com.helger.peppol.utils.PeppolKeyStoreHelper;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.x500.X500Principal;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PeppolCertificateChecker {
    public static final boolean DEFAULT_OSCP_CHECK_ENABLED = true;
    public static final boolean DEFAULT_CACHE_OSCP_RESULTS = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolCertificateChecker.class);
    private static final ICommonsList<X509Certificate> PEPPOL_AP_CA_CERTS = new CommonsArrayList<X509Certificate>();
    private static final ICommonsList<X500Principal> PEPPOL_AP_CA_ISSUERS;
    private static final ICommonsList<X509Certificate> PEPPOL_SMP_CA_CERTS;
    private static final ICommonsList<X500Principal> PEPPOL_SMP_CA_ISSUERS;
    private static final AtomicBoolean OCSP_ENABLED;
    private static final AtomicBoolean CACHE_OCSP_RESULTS;
    private static final SimpleReadWriteLock s_aRWLock;
    @GuardedBy(value="s_aRWLock")
    private static Consumer<? super GeneralSecurityException> s_aExceptionHdl;
    private static final PeppolRevocationCache REVOCATION_CACHE_AP;
    private static final PeppolRevocationCache REVOCATION_CACHE_SMP;

    private PeppolCertificateChecker() {
    }

    public static boolean isOCSPEnabled() {
        return OCSP_ENABLED.get();
    }

    public static void setOCSPEnabled(boolean bl) {
        OCSP_ENABLED.set(bl);
    }

    public static boolean isCacheOCSPResults() {
        return CACHE_OCSP_RESULTS.get();
    }

    public static void setCacheOCSPResults(boolean bl) {
        CACHE_OCSP_RESULTS.set(bl);
    }

    public static void clearOCSPCache() {
        REVOCATION_CACHE_AP.clearCache();
        REVOCATION_CACHE_SMP.clearCache();
    }

    @Nonnull
    public static Consumer<? super GeneralSecurityException> getExceptionHdl() {
        return s_aRWLock.readLockedGet(() -> s_aExceptionHdl);
    }

    public static void setExceptionHdl(@Nonnull Consumer<? super GeneralSecurityException> consumer) {
        ValueEnforcer.notNull(consumer, "ExceptionHdl");
        s_aRWLock.writeLockedGet(() -> {
            s_aExceptionHdl = consumer;
            return s_aExceptionHdl;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCertificateRevoked(@Nonnull X509Certificate x509Certificate2, @Nonnull ICommonsList<X509Certificate> iCommonsList, @Nullable LocalDateTime localDateTime, @Nonnull ETriState eTriState, @Nonnull Consumer<? super GeneralSecurityException> consumer) {
        ValueEnforcer.notNull(x509Certificate2, "Cert");
        ValueEnforcer.notEmpty(iCommonsList, "ValidCAs");
        ValueEnforcer.notNull(eTriState, "CheckOSCP");
        ValueEnforcer.notNull(consumer, "ExceptionHdl");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performing certificate revocation check on certificate '" + x509Certificate2.getSubjectX500Principal().getName() + "'" + (localDateTime != null ? " for datetime " + localDateTime : ""));
        }
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            Object object;
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificate(x509Certificate2);
            CommonsHashSet<TrustAnchor> commonsHashSet = new CommonsHashSet<TrustAnchor>(iCommonsList, x509Certificate -> new TrustAnchor((X509Certificate)x509Certificate, null));
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(commonsHashSet, (CertSelector)x509CertSelector);
            pKIXBuilderParameters.setRevocationEnabled(true);
            boolean bl = eTriState.isUndefined() ? PeppolCertificateChecker.isOCSPEnabled() : eTriState.isTrue();
            try {
                Security.setProperty("ocsp.enable", Boolean.toString(bl));
            }
            catch (SecurityException securityException) {
                LOGGER.warn("Failed to set Security property 'ocsp.enable' to '" + bl + "'");
            }
            if (localDateTime != null) {
                object = PDTFactory.createDate(localDateTime);
                pKIXBuilderParameters.setDate((Date)object);
            }
            object = CertStore.getInstance("Collection", new CollectionCertStoreParameters(iCommonsList));
            pKIXBuilderParameters.addCertStore((CertStore)object);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker pKIXRevocationChecker = (PKIXRevocationChecker)certPathBuilder.getRevocationChecker();
            pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.ONLY_END_ENTITY));
            PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("OCSP/CLR builder result = " + pKIXCertPathBuilderResult);
            }
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(pKIXCertPathBuilderResult.getCertPath(), pKIXBuilderParameters);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("OCSP/CLR validation result = " + pKIXCertPathValidatorResult);
            }
            boolean bl2 = false;
            return bl2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            consumer.accept(generalSecurityException);
            boolean bl = true;
            return bl;
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            if (l > 500L) {
                LOGGER.warn("OCSP/CLR revocation check took " + l + " milliseconds which is too long");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("OCSP/CLR revocation check took " + l + " milliseconds");
            }
        }
    }

    public static boolean isPeppolAPCertificateRevoked(@Nonnull X509Certificate x509Certificate, @Nullable LocalDateTime localDateTime, @Nonnull ETriState eTriState, @Nonnull Consumer<? super GeneralSecurityException> consumer) {
        return PeppolCertificateChecker.isCertificateRevoked(x509Certificate, PEPPOL_AP_CA_CERTS, localDateTime, eTriState, consumer);
    }

    public static boolean isPeppolSMPCertificateRevoked(@Nonnull X509Certificate x509Certificate, @Nullable LocalDateTime localDateTime, @Nonnull ETriState eTriState, @Nonnull Consumer<? super GeneralSecurityException> consumer) {
        return PeppolCertificateChecker.isCertificateRevoked(x509Certificate, PEPPOL_SMP_CA_CERTS, localDateTime, eTriState, consumer);
    }

    @Nonnull
    private static EPeppolCertificateCheckResult _checkCertificate(@Nullable X509Certificate x509Certificate, @Nullable LocalDateTime localDateTime, @Nonnull ICommonsList<X500Principal> iCommonsList, @Nonnull ICommonsList<X509Certificate> iCommonsList2, @Nullable PeppolRevocationCache peppolRevocationCache, @Nonnull ETriState eTriState) {
        boolean bl;
        if (x509Certificate == null) {
            return EPeppolCertificateCheckResult.NO_CERTIFICATE_PROVIDED;
        }
        Date date = PDTFactory.createDate(localDateTime);
        try {
            if (date == null) {
                x509Certificate.checkValidity();
            } else {
                x509Certificate.checkValidity(date);
            }
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return EPeppolCertificateCheckResult.NOT_YET_VALID;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return EPeppolCertificateCheckResult.EXPIRED;
        }
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        if (!iCommonsList.contains(x500Principal)) {
            return EPeppolCertificateCheckResult.UNSUPPORTED_ISSUER;
        }
        if (peppolRevocationCache != null ? (bl = peppolRevocationCache.isRevoked(x509Certificate)) : PeppolCertificateChecker.isCertificateRevoked(x509Certificate, iCommonsList2, localDateTime, eTriState, PeppolCertificateChecker.getExceptionHdl())) {
            return EPeppolCertificateCheckResult.REVOKED;
        }
        return EPeppolCertificateCheckResult.VALID;
    }

    @Nonnull
    public static EPeppolCertificateCheckResult checkPeppolAPCertificate(@Nullable X509Certificate x509Certificate, @Nullable LocalDateTime localDateTime, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2) {
        boolean bl = eTriState.isUndefined() ? PeppolCertificateChecker.isCacheOCSPResults() : eTriState.isTrue();
        return PeppolCertificateChecker._checkCertificate(x509Certificate, localDateTime, PEPPOL_AP_CA_ISSUERS, PEPPOL_AP_CA_CERTS, bl ? REVOCATION_CACHE_AP : null, eTriState2);
    }

    @Nonnull
    public static EPeppolCertificateCheckResult checkPeppolSMPCertificate(@Nullable X509Certificate x509Certificate, @Nullable LocalDateTime localDateTime, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2) {
        boolean bl = eTriState.isUndefined() ? PeppolCertificateChecker.isCacheOCSPResults() : eTriState.isTrue();
        return PeppolCertificateChecker._checkCertificate(x509Certificate, localDateTime, PEPPOL_SMP_CA_ISSUERS, PEPPOL_SMP_CA_CERTS, bl ? REVOCATION_CACHE_SMP : null, eTriState2);
    }

    static {
        PEPPOL_SMP_CA_CERTS = new CommonsArrayList<X509Certificate>();
        PEPPOL_AP_CA_CERTS.add(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_AP);
        PEPPOL_AP_CA_CERTS.add(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_AP);
        PEPPOL_SMP_CA_CERTS.add(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_SMP);
        PEPPOL_SMP_CA_CERTS.add(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_SMP);
        PEPPOL_AP_CA_ISSUERS = new CommonsArrayList<X500Principal>(PEPPOL_AP_CA_CERTS, X509Certificate::getSubjectX500Principal);
        PEPPOL_SMP_CA_ISSUERS = new CommonsArrayList<X500Principal>(PEPPOL_SMP_CA_CERTS, X509Certificate::getSubjectX500Principal);
        OCSP_ENABLED = new AtomicBoolean(true);
        CACHE_OCSP_RESULTS = new AtomicBoolean(true);
        s_aRWLock = new SimpleReadWriteLock();
        s_aExceptionHdl = generalSecurityException -> LOGGER.warn("Certificate is revoked", (Throwable)generalSecurityException);
        REVOCATION_CACHE_AP = new PeppolRevocationCache(x509Certificate -> PeppolCertificateChecker.isPeppolAPCertificateRevoked(x509Certificate, null, ETriState.UNDEFINED, PeppolCertificateChecker.getExceptionHdl()));
        REVOCATION_CACHE_SMP = new PeppolRevocationCache(x509Certificate -> PeppolCertificateChecker.isPeppolSMPCertificateRevoked(x509Certificate, null, ETriState.UNDEFINED, PeppolCertificateChecker.getExceptionHdl()));
    }

    @ThreadSafe
    private static final class PeppolRevocationCache {
        private final ExpiringMap<String, Boolean> m_aCache = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).expiration(6L, TimeUnit.HOURS).build();
        private final IFunction<X509Certificate, Boolean> m_aValueProvider;

        public PeppolRevocationCache(@Nonnull IFunction<X509Certificate, Boolean> iFunction) {
            this.m_aValueProvider = iFunction;
        }

        @Nonnull
        private static String _getKey(@Nonnull X509Certificate x509Certificate) {
            return x509Certificate.getSubjectX500Principal().getName() + "-" + x509Certificate.getSerialNumber().toString();
        }

        public boolean isRevoked(@Nonnull X509Certificate x509Certificate) {
            String string2 = PeppolRevocationCache._getKey(x509Certificate);
            return this.m_aCache.computeIfAbsent(string2, string -> (Boolean)this.m_aValueProvider.apply(x509Certificate));
        }

        public void clearCache() {
            this.m_aCache.clear();
        }
    }
}

