/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sml;

import com.helger.commons.string.StringParser;
import com.helger.peppol.sml.SMLInfo;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SMLInfoMicroTypeConverter
implements IMicroTypeConverter<SMLInfo> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISPLAY_NAME = "displayname";
    private static final String ELEMENT_DNS_ZONE = "dnszone";
    private static final String ELEMENT_MANAGEMENT_SERVICE = "mgmtsvc";
    private static final String ATTR_REQUIRES_CLIENT_CERT = "clientcert";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull SMLInfo sMLInfo, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, sMLInfo.getID());
        microElement.setAttribute(ATTR_DISPLAY_NAME, sMLInfo.getDisplayName());
        microElement.appendElement(string, ELEMENT_DNS_ZONE).appendText(sMLInfo.getDNSZone());
        microElement.appendElement(string, ELEMENT_MANAGEMENT_SERVICE).appendText(sMLInfo.getManagementServiceURL());
        microElement.setAttribute(ATTR_REQUIRES_CLIENT_CERT, sMLInfo.isClientCertificateRequired());
        return microElement;
    }

    @Override
    @Nonnull
    public SMLInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        String string2 = iMicroElement.getAttributeValue(ATTR_DISPLAY_NAME);
        String string3 = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_DNS_ZONE);
        String string4 = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_MANAGEMENT_SERVICE);
        boolean bl = StringParser.parseBool(iMicroElement.getAttributeValue(ATTR_REQUIRES_CLIENT_CERT), true);
        return new SMLInfo(string, string2, string3, string4, bl);
    }
}

