/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v2;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.v2.PD2BusinessEntityType;
import com.helger.pd.businesscard.v2.PD2IdentifierType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessCardType", propOrder={"participantIdentifier", "businessEntity"})
@CodingStyleguideUnaware
public class PD2BusinessCardType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="ParticipantIdentifier", required=true)
    private PD2IdentifierType participantIdentifier;
    @XmlElement(name="BusinessEntity")
    private List<PD2BusinessEntityType> businessEntity;

    @Nullable
    public PD2IdentifierType getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public void setParticipantIdentifier(@Nullable PD2IdentifierType pD2IdentifierType) {
        this.participantIdentifier = pD2IdentifierType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PD2BusinessEntityType> getBusinessEntity() {
        if (this.businessEntity == null) {
            this.businessEntity = new ArrayList<PD2BusinessEntityType>();
        }
        return this.businessEntity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PD2BusinessCardType pD2BusinessCardType = (PD2BusinessCardType)object;
        if (!EqualsHelper.equalsCollection(this.businessEntity, pD2BusinessCardType.businessEntity)) {
            return false;
        }
        return EqualsHelper.equals(this.participantIdentifier, pD2BusinessCardType.participantIdentifier);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.businessEntity)).append(this.participantIdentifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("businessEntity", this.businessEntity).append("participantIdentifier", this.participantIdentifier).getToString();
    }

    public void setBusinessEntity(@Nullable List<PD2BusinessEntityType> list) {
        this.businessEntity = list;
    }

    public boolean hasBusinessEntityEntries() {
        return !this.getBusinessEntity().isEmpty();
    }

    public boolean hasNoBusinessEntityEntries() {
        return this.getBusinessEntity().isEmpty();
    }

    @Nonnegative
    public int getBusinessEntityCount() {
        return this.getBusinessEntity().size();
    }

    @Nullable
    public PD2BusinessEntityType getBusinessEntityAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getBusinessEntity().get(n);
    }

    public void addBusinessEntity(@Nonnull PD2BusinessEntityType pD2BusinessEntityType) {
        this.getBusinessEntity().add(pD2BusinessEntityType);
    }

    public void cloneTo(@Nonnull PD2BusinessCardType pD2BusinessCardType) {
        if (this.businessEntity == null) {
            pD2BusinessCardType.businessEntity = null;
        } else {
            ArrayList<PD2BusinessEntityType> arrayList = new ArrayList<PD2BusinessEntityType>();
            for (PD2BusinessEntityType pD2BusinessEntityType : this.getBusinessEntity()) {
                arrayList.add(pD2BusinessEntityType == null ? null : pD2BusinessEntityType.clone());
            }
            pD2BusinessCardType.businessEntity = arrayList;
        }
        pD2BusinessCardType.participantIdentifier = this.participantIdentifier == null ? null : this.participantIdentifier.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PD2BusinessCardType clone() {
        PD2BusinessCardType pD2BusinessCardType = new PD2BusinessCardType();
        this.cloneTo(pD2BusinessCardType);
        return pD2BusinessCardType;
    }
}

