/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.v1;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pd.businesscard.v1.PD1BusinessEntityType;
import com.helger.pd.businesscard.v1.PD1IdentifierType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BusinessCardType", propOrder={"participantIdentifier", "businessEntity"})
@CodingStyleguideUnaware
public class PD1BusinessCardType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="ParticipantIdentifier", required=true)
    private PD1IdentifierType participantIdentifier;
    @XmlElement(name="BusinessEntity")
    private List<PD1BusinessEntityType> businessEntity;

    @Nullable
    public PD1IdentifierType getParticipantIdentifier() {
        return this.participantIdentifier;
    }

    public void setParticipantIdentifier(@Nullable PD1IdentifierType pD1IdentifierType) {
        this.participantIdentifier = pD1IdentifierType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<PD1BusinessEntityType> getBusinessEntity() {
        if (this.businessEntity == null) {
            this.businessEntity = new ArrayList<PD1BusinessEntityType>();
        }
        return this.businessEntity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PD1BusinessCardType pD1BusinessCardType = (PD1BusinessCardType)object;
        if (!EqualsHelper.equalsCollection(this.businessEntity, pD1BusinessCardType.businessEntity)) {
            return false;
        }
        return EqualsHelper.equals(this.participantIdentifier, pD1BusinessCardType.participantIdentifier);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.businessEntity)).append(this.participantIdentifier).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("businessEntity", this.businessEntity).append("participantIdentifier", this.participantIdentifier).getToString();
    }

    public void setBusinessEntity(@Nullable List<PD1BusinessEntityType> list) {
        this.businessEntity = list;
    }

    public boolean hasBusinessEntityEntries() {
        return !this.getBusinessEntity().isEmpty();
    }

    public boolean hasNoBusinessEntityEntries() {
        return this.getBusinessEntity().isEmpty();
    }

    @Nonnegative
    public int getBusinessEntityCount() {
        return this.getBusinessEntity().size();
    }

    @Nullable
    public PD1BusinessEntityType getBusinessEntityAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getBusinessEntity().get(n);
    }

    public void addBusinessEntity(@Nonnull PD1BusinessEntityType pD1BusinessEntityType) {
        this.getBusinessEntity().add(pD1BusinessEntityType);
    }

    public void cloneTo(@Nonnull PD1BusinessCardType pD1BusinessCardType) {
        if (this.businessEntity == null) {
            pD1BusinessCardType.businessEntity = null;
        } else {
            ArrayList<PD1BusinessEntityType> arrayList = new ArrayList<PD1BusinessEntityType>();
            for (PD1BusinessEntityType pD1BusinessEntityType : this.getBusinessEntity()) {
                arrayList.add(pD1BusinessEntityType == null ? null : pD1BusinessEntityType.clone());
            }
            pD1BusinessCardType.businessEntity = arrayList;
        }
        pD1BusinessCardType.participantIdentifier = this.participantIdentifier == null ? null : this.participantIdentifier.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PD1BusinessCardType clone() {
        PD1BusinessCardType pD1BusinessCardType = new PD1BusinessCardType();
        this.cloneTo(pD1BusinessCardType);
        return pD1BusinessCardType;
    }
}

