/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.locale.language.LanguageCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PDName
implements Serializable {
    private final String m_sName;
    private final String m_sLanguageCode;

    public static boolean isValidLanguageCode(@Nullable String string) {
        return string == null || string.length() == 2 && LanguageCache.getInstance().containsLanguage(string);
    }

    public PDName(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public PDName(@Nonnull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.isTrue(PDName.isValidLanguageCode(string2), () -> "'" + string2 + "' is invalid language code");
        this.m_sName = string;
        this.m_sLanguageCode = LocaleHelper.getValidLanguageCode(string2);
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nullable
    public String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    public boolean hasNoLanguageCode() {
        return StringHelper.hasNoText(this.m_sLanguageCode);
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute("name", this.m_sName);
        microElement.setAttribute("language", this.m_sLanguageCode);
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", this.m_sName);
        if (this.m_sLanguageCode != null) {
            jsonObject.add("language", this.m_sLanguageCode);
        }
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDName pDName = (PDName)object;
        return this.m_sName.equals(pDName.m_sName) && EqualsHelper.equals(this.m_sLanguageCode, pDName.m_sLanguageCode);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sName).append(this.m_sLanguageCode).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Name", this.m_sName).appendIfNotNull("LanguageCode", this.m_sLanguageCode).getToString();
    }
}

