/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.pd.businesscard.generic.PDContact;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.pd.businesscard.generic.PDName;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDBusinessEntity
implements Serializable,
ICloneable<PDBusinessEntity> {
    private final ICommonsList<PDName> m_aNames = new CommonsArrayList<PDName>();
    private String m_sCountryCode;
    private String m_sGeoInfo;
    private final ICommonsList<PDIdentifier> m_aIDs = new CommonsArrayList<PDIdentifier>();
    private final ICommonsList<String> m_aWebsiteURIs = new CommonsArrayList<String>();
    private final ICommonsList<PDContact> m_aContacts = new CommonsArrayList<PDContact>();
    private String m_sAdditionalInfo;
    private LocalDate m_aRegistrationDate;

    public PDBusinessEntity() {
    }

    public PDBusinessEntity(@Nullable ICommonsList<PDName> iCommonsList, @Nullable String string, @Nullable String string2, @Nullable ICommonsList<PDIdentifier> iCommonsList2, @Nullable ICommonsList<String> iCommonsList3, @Nullable ICommonsList<PDContact> iCommonsList4, @Nullable String string3, @Nullable LocalDate localDate) {
        this.names().setAll((Iterable<PDName>)iCommonsList);
        this.setCountryCode(string);
        this.setGeoInfo(string2);
        this.identifiers().setAll((Iterable<PDIdentifier>)iCommonsList2);
        this.websiteURIs().setAll((Iterable<String>)iCommonsList3);
        this.contacts().setAllMapped(iCommonsList4, PDContact::getClone);
        this.setAdditionalInfo(string3);
        this.setRegistrationDate(localDate);
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDName> names() {
        return this.m_aNames;
    }

    @Nullable
    public final String getCountryCode() {
        return this.m_sCountryCode;
    }

    public final boolean hasCountryCode() {
        return StringHelper.hasText(this.m_sCountryCode);
    }

    public final void setCountryCode(@Nullable String string) {
        this.m_sCountryCode = string;
    }

    @Nullable
    public final String getGeoInfo() {
        return this.m_sGeoInfo;
    }

    public final boolean hasGeoInfo() {
        return StringHelper.hasText(this.m_sGeoInfo);
    }

    public final void setGeoInfo(@Nullable String string) {
        this.m_sGeoInfo = string;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDIdentifier> identifiers() {
        return this.m_aIDs;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<String> websiteURIs() {
        return this.m_aWebsiteURIs;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PDContact> contacts() {
        return this.m_aContacts;
    }

    @Nullable
    public final String getAdditionalInfo() {
        return this.m_sAdditionalInfo;
    }

    public final boolean hasAdditionalInfo() {
        return StringHelper.hasText(this.m_sAdditionalInfo);
    }

    public final void setAdditionalInfo(@Nullable String string) {
        this.m_sAdditionalInfo = string;
    }

    @Nullable
    public final LocalDate getRegistrationDate() {
        return this.m_aRegistrationDate;
    }

    public final boolean hasRegistrationDate() {
        return this.m_aRegistrationDate != null;
    }

    public final void setRegistrationDate(@Nullable LocalDate localDate) {
        this.m_aRegistrationDate = localDate;
    }

    public void cloneTo(@Nonnull PDBusinessEntity pDBusinessEntity) {
        pDBusinessEntity.m_aNames.setAll((Iterable<PDName>)this.m_aNames);
        pDBusinessEntity.m_sCountryCode = this.m_sCountryCode;
        pDBusinessEntity.m_sGeoInfo = this.m_sGeoInfo;
        pDBusinessEntity.m_aIDs.setAll((Iterable<PDIdentifier>)this.m_aIDs);
        pDBusinessEntity.m_aWebsiteURIs.setAll((Iterable<String>)this.m_aWebsiteURIs);
        pDBusinessEntity.m_aContacts.setAllMapped(this.m_aContacts, PDContact::getClone);
        pDBusinessEntity.m_sAdditionalInfo = this.m_sAdditionalInfo;
        pDBusinessEntity.m_aRegistrationDate = this.m_aRegistrationDate;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessEntity getClone() {
        PDBusinessEntity pDBusinessEntity = new PDBusinessEntity();
        this.cloneTo(pDBusinessEntity);
        return pDBusinessEntity;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        for (PDName object : this.m_aNames) {
            microElement.appendChild(object.getAsMicroXML(string, "name"));
        }
        microElement.setAttribute("countrycode", this.m_sCountryCode);
        if (this.hasGeoInfo()) {
            microElement.appendElement(string, "geoinfo").appendText(this.m_sGeoInfo);
        }
        for (PDIdentifier pDIdentifier : this.m_aIDs) {
            microElement.appendChild(pDIdentifier.getAsMicroXML(string, "id"));
        }
        for (String string3 : this.m_aWebsiteURIs) {
            microElement.appendElement(string, "website").appendText(string3);
        }
        for (PDContact pDContact : this.m_aContacts) {
            microElement.appendChild(pDContact.getAsMicroXML(string, "contact"));
        }
        if (this.hasAdditionalInfo()) {
            microElement.appendElement(string, "additionalinfo").appendText(this.m_sAdditionalInfo);
        }
        if (this.hasRegistrationDate()) {
            microElement.appendElement(string, "regdate").appendText(PDTWebDateHelper.getAsStringXSD(this.m_aRegistrationDate));
        }
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJson("name", (IJson)new JsonArray().addAllMapped(this.m_aNames, PDName::getAsJson));
        jsonObject.add("countrycode", this.m_sCountryCode);
        if (this.hasGeoInfo()) {
            jsonObject.add("geoinfo", this.m_sGeoInfo);
        }
        if (this.m_aIDs.isNotEmpty()) {
            jsonObject.addJson("id", (IJson)new JsonArray().addAllMapped(this.m_aIDs, PDIdentifier::getAsJson));
        }
        if (this.m_aWebsiteURIs.isNotEmpty()) {
            jsonObject.addJson("website", (IJson)new JsonArray().addAll(this.m_aWebsiteURIs));
        }
        if (this.m_aContacts.isNotEmpty()) {
            jsonObject.addJson("contact", (IJson)new JsonArray().addAllMapped(this.m_aContacts, PDContact::getAsJson));
        }
        if (this.hasAdditionalInfo()) {
            jsonObject.add("additionalinfo", this.m_sAdditionalInfo);
        }
        if (this.hasRegistrationDate()) {
            jsonObject.add("regdate", PDTWebDateHelper.getAsStringXSD(this.m_aRegistrationDate));
        }
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessEntity pDBusinessEntity = (PDBusinessEntity)object;
        return EqualsHelper.equals(this.m_aNames, pDBusinessEntity.m_aNames) && EqualsHelper.equals(this.m_sCountryCode, pDBusinessEntity.m_sCountryCode) && EqualsHelper.equals(this.m_sGeoInfo, pDBusinessEntity.m_sGeoInfo) && EqualsHelper.equals(this.m_aIDs, pDBusinessEntity.m_aIDs) && EqualsHelper.equals(this.m_aWebsiteURIs, pDBusinessEntity.m_aWebsiteURIs) && EqualsHelper.equals(this.m_aContacts, pDBusinessEntity.m_aContacts) && EqualsHelper.equals(this.m_sAdditionalInfo, pDBusinessEntity.m_sAdditionalInfo) && EqualsHelper.equals(this.m_aRegistrationDate, pDBusinessEntity.m_aRegistrationDate);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aNames)).append(this.m_sCountryCode).append(this.m_sGeoInfo).append(this.m_aIDs)).append(this.m_aWebsiteURIs)).append(this.m_aContacts)).append(this.m_sAdditionalInfo).append(this.m_aRegistrationDate).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("names", this.m_aNames).append("countryCode", this.m_sCountryCode).append("geographicalInformation", this.m_sGeoInfo).append("identifier", this.m_aIDs).append("websiteURI", this.m_aWebsiteURIs).append("contact", this.m_aContacts).append("additionalInformation", this.m_sAdditionalInfo).append("registrationDate", this.m_aRegistrationDate).getToString();
    }
}

