/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pd.businesscard.generic;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.pd.businesscard.generic.PDBusinessEntity;
import com.helger.pd.businesscard.generic.PDIdentifier;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PDBusinessCard
implements Serializable,
ICloneable<PDBusinessCard> {
    private PDIdentifier m_aParticipantIdentifier;
    private ICommonsList<PDBusinessEntity> m_aEntities = new CommonsArrayList<PDBusinessEntity>();

    @Nullable
    public PDIdentifier getParticipantIdentifier() {
        return this.m_aParticipantIdentifier;
    }

    @Nonnull
    public PDBusinessCard setParticipantIdentifier(@Nullable PDIdentifier pDIdentifier) {
        this.m_aParticipantIdentifier = pDIdentifier;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<PDBusinessEntity> businessEntities() {
        return this.m_aEntities;
    }

    public void cloneTo(@Nonnull PDBusinessCard pDBusinessCard) {
        pDBusinessCard.m_aParticipantIdentifier = this.m_aParticipantIdentifier;
        pDBusinessCard.m_aEntities = new CommonsArrayList<PDBusinessEntity>(this.m_aEntities, PDBusinessEntity::getClone);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public PDBusinessCard getClone() {
        PDBusinessCard pDBusinessCard = new PDBusinessCard();
        this.cloneTo(pDBusinessCard);
        return pDBusinessCard;
    }

    @Nonnull
    public IMicroElement getAsMicroXML(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.appendChild(this.m_aParticipantIdentifier.getAsMicroXML(string, "participant"));
        for (PDBusinessEntity pDBusinessEntity : this.m_aEntities) {
            microElement.appendChild(pDBusinessEntity.getAsMicroXML(string, "entity"));
        }
        return microElement;
    }

    @Nonnull
    public IJsonObject getAsJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJson("participant", this.m_aParticipantIdentifier.getAsJson());
        jsonObject.addJson("entity", (IJson)new JsonArray().addAllMapped(this.m_aEntities, PDBusinessEntity::getAsJson));
        return jsonObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PDBusinessCard pDBusinessCard = (PDBusinessCard)object;
        return EqualsHelper.equals(this.m_aParticipantIdentifier, pDBusinessCard.m_aParticipantIdentifier) && EqualsHelper.equals(this.m_aEntities, pDBusinessCard.m_aEntities);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aParticipantIdentifier).append(this.m_aEntities)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ParticipantIdentifier", this.m_aParticipantIdentifier).append("Entities", this.m_aEntities).getToString();
    }
}

