/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.commons.string.ToStringGenerator;
import com.helger.json.convert.JsonEscapeHelper;
import com.helger.json.valueserializer.IJsonValueSerializer;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class JsonValueSerializerEscaped
implements IJsonValueSerializer {
    private static final JsonValueSerializerEscaped s_aInstance = new JsonValueSerializerEscaped();

    private JsonValueSerializerEscaped() {
    }

    @Nonnull
    public static JsonValueSerializerEscaped getInstance() {
        return s_aInstance;
    }

    public static void appendEscapedJsonString(@Nonnull String string, @Nonnull @WillNotClose Writer writer) throws IOException {
        writer.write(34);
        JsonEscapeHelper.jsonEscapeToWriter(string, writer);
        writer.write(34);
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @Nonnull @WillNotClose Writer writer) throws IOException {
        JsonValueSerializerEscaped.appendEscapedJsonString(String.valueOf(object), writer);
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

