/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.NonClosingReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.EValidity;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.parser.IJsonParserCustomizeCallback;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.JsonParser;
import com.helger.json.parser.errorhandler.IJsonParseExceptionCallback;
import com.helger.json.parser.errorhandler.LoggingJsonParseExceptionCallback;
import com.helger.json.parser.handler.CollectingJsonParserHandler;
import com.helger.json.parser.handler.DoNothingJsonParserHandler;
import com.helger.json.parser.handler.IJsonParserHandler;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JsonReader {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonReader.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IJsonParseExceptionCallback s_aDefaultParseExceptionCallback = new LoggingJsonParseExceptionCallback();
    private static final JsonReader s_aInstance = new JsonReader();

    private JsonReader() {
    }

    @Nonnull
    public static IJsonParseExceptionCallback getDefaultParseExceptionCallback() {
        return s_aRWLock.readLockedGet(() -> s_aDefaultParseExceptionCallback);
    }

    public static void setDefaultParseExceptionCallback(@Nonnull IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull(iJsonParseExceptionCallback, "DefaultParseExceptionCallback");
        s_aRWLock.writeLockedGet(() -> {
            s_aDefaultParseExceptionCallback = iJsonParseExceptionCallback;
            return s_aDefaultParseExceptionCallback;
        });
    }

    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler) {
        return JsonReader.parseJson(reader, iJsonParserHandler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler, @Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(iJsonParserHandler, "ParserHandler");
        try {
            JsonParser jsonParser = new JsonParser(reader, iJsonParserHandler);
            if (iJsonParserCustomizeCallback != null) {
                iJsonParserCustomizeCallback.customizeJsonParser(jsonParser);
            }
            jsonParser.parse();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (JsonParseException jsonParseException) {
            if (iJsonParseExceptionCallback != null) {
                iJsonParseExceptionCallback.onException(jsonParseException);
            } else {
                JsonReader.getDefaultParseExceptionCallback().onException(jsonParseException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    @Nonnull
    private static EValidity _validateJson(@Nonnull @WillClose Reader reader) {
        ESuccess eSuccess = JsonReader.parseJson(reader, new DoNothingJsonParserHandler(), null, jsonParseException -> {});
        return EValidity.valueOf(eSuccess.isSuccess());
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull File file) {
        return JsonReader.isValidJson(file, DEFAULT_CHARSET);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull File file, @Nonnull Charset charset) {
        return JsonReader.isValidJson(new FileSystemResource(file), charset);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull Path path) {
        return JsonReader.isValidJson(path, DEFAULT_CHARSET);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull Path path, @Nonnull Charset charset) {
        return JsonReader.isValidJson(new FileSystemResource(path), charset);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull IHasInputStream iHasInputStream) {
        return JsonReader.isValidJson(iHasInputStream, DEFAULT_CHARSET);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
        ValueEnforcer.notNull(charset, "FallbackCharset");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to open Json InputStream from " + iHasInputStream);
            }
            return false;
        }
        return JsonReader.isValidJson(inputStream, charset);
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull @WillClose InputStream inputStream) {
        return JsonReader.isValidJson(inputStream, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean isValidJson(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(charset, "FallbackCharset");
        try {
            InputStreamReader inputStreamReader = CharsetHelper.getReaderByBOM(inputStream, charset);
            boolean bl = JsonReader.isValidJson(inputStreamReader);
            return bl;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Json");
        return JsonReader.isValidJson(new NonBlockingStringReader(string));
    }

    @Deprecated
    public static boolean isValidJson(@Nonnull @WillClose Reader reader) {
        ValueEnforcer.notNull(reader, "Reader");
        return JsonReader._validateJson(StreamHelper.getBuffered(reader)).isValid();
    }

    @Nullable
    public static IJson readJson(@Nonnull @WillClose Reader reader, @Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        CollectingJsonParserHandler collectingJsonParserHandler = new CollectingJsonParserHandler();
        if (JsonReader.parseJson(reader, collectingJsonParserHandler, iJsonParserCustomizeCallback, iJsonParseExceptionCallback).isFailure()) {
            return null;
        }
        return collectingJsonParserHandler.getJson();
    }

    @Nullable
    public static IJson readFromString(@Nonnull String string) {
        return JsonReader.builder().setSource(string).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromString(@Nonnull String string, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.builder().setSource(string).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromFile(@Nonnull File file) {
        return JsonReader.builder().setSource(file).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromFile(@Nonnull File file, @Nonnull Charset charset) {
        return JsonReader.builder().setSource(file, charset).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.builder().setSource(file, charset).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromPath(@Nonnull Path path) {
        return JsonReader.builder().setSource(path).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromPath(@Nonnull Path path, @Nonnull Charset charset) {
        return JsonReader.builder().setSource(path, charset).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromPath(@Nonnull Path path, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.builder().setSource(path, charset).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream) {
        return JsonReader.builder().setSource(iHasInputStream).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        return JsonReader.builder().setSource(iHasInputStream, charset).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.builder().setSource(iHasInputStream, charset).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull InputStream inputStream) {
        return JsonReader.builder().setSource(inputStream).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull InputStream inputStream, @Nonnull Charset charset) {
        return JsonReader.builder().setSource(inputStream, charset).read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Deprecated
    public static IJson readFromStream(@Nonnull InputStream inputStream, @Nonnull Charset charset, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        try {
            IJson iJson = JsonReader.builder().setSource(inputStream, charset).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
            return iJson;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Nullable
    @Deprecated
    public static IJson readFromReader(@Nonnull Reader reader) {
        return JsonReader.builder().setSource(reader).read();
    }

    @Nullable
    @Deprecated
    public static IJson readFromReader(@Nonnull Reader reader, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        return JsonReader.builder().setSource(reader).setCustomExceptionCallback(iJsonParseExceptionCallback).read();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builderMultiObject() {
        return JsonReader.builder().setDontCloseSource(true).setUseBufferedReader(false).setCustomizeCallback(jsonParser -> jsonParser.setCheckForEOI(false));
    }

    public static class Builder
    implements AutoCloseable {
        private boolean m_bDontCloseSource = false;
        private boolean m_bUseBufferedReader = true;
        private Reader m_aReader;
        private IJsonParserCustomizeCallback m_aCustomizeCallback;
        private IJsonParseExceptionCallback m_aCustomeExceptionCallback;

        @Override
        public void close() {
            StreamHelper.close(this.m_aReader);
        }

        @Nonnull
        public Builder setDontCloseSource(boolean bl) {
            this.m_bDontCloseSource = bl;
            return this;
        }

        @Nonnull
        public Builder setUseBufferedReader(boolean bl) {
            this.m_bUseBufferedReader = bl;
            return this;
        }

        @Nonnull
        public Builder setSource(@Nonnull String string) {
            ValueEnforcer.notNull(string, "Json");
            return this.setSource(new NonBlockingStringReader(string));
        }

        @Nonnull
        public Builder setSource(@Nonnull File file) {
            return this.setSource(file, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder setSource(@Nonnull File file, @Nonnull Charset charset) {
            ValueEnforcer.notNull(file, "File");
            ValueEnforcer.notNull(charset, "FallbackCharset");
            return this.setSource(new FileSystemResource(file), charset);
        }

        @Nonnull
        public Builder setSource(@Nonnull Path path) {
            return this.setSource(path, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder setSource(@Nonnull Path path, @Nonnull Charset charset) {
            ValueEnforcer.notNull(path, "Path");
            ValueEnforcer.notNull(charset, "FallbackCharset");
            return this.setSource(new FileSystemResource(path), charset);
        }

        @Nonnull
        public Builder setSource(@Nonnull byte[] byArray) {
            return this.setSource(byArray, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder setSource(@Nonnull byte[] byArray, @Nonnull Charset charset) {
            ValueEnforcer.notNull(byArray, "Bytes");
            ValueEnforcer.notNull(charset, "FallbackCharset");
            return this.setSource(new NonBlockingByteArrayInputStream(byArray), charset);
        }

        @Nonnull
        public Builder setSource(@Nonnull IHasInputStream iHasInputStream) {
            return this.setSource(iHasInputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder setSource(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull(iHasInputStream, "InputStreamProvider");
            ValueEnforcer.notNull(charset, "FallbackCharset");
            InputStream inputStream = iHasInputStream.getInputStream();
            if (inputStream != null) {
                this.setSource(inputStream, charset);
            }
            return this;
        }

        @Nonnull
        public Builder setSource(@Nonnull @WillClose InputStream inputStream) {
            return this.setSource(inputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public Builder setSource(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull(inputStream, "InputStream");
            ValueEnforcer.notNull(charset, "FallbackCharset");
            InputStreamReader inputStreamReader = CharsetHelper.getReaderByBOM(inputStream, charset);
            if (inputStreamReader != null) {
                return this.setSource(inputStreamReader);
            }
            return this;
        }

        @Nonnull
        public Builder setSource(@Nonnull @WillClose Reader reader) {
            ValueEnforcer.notNull(reader, "Reader");
            if (this.m_aReader != null) {
                LOGGER.warn("Another source is already present - this may cause a resource leak, because the old source is not closed automatically");
            }
            this.m_aReader = reader;
            if (this.m_bUseBufferedReader) {
                this.m_aReader = StreamHelper.getBuffered(this.m_aReader);
            }
            if (this.m_bDontCloseSource) {
                this.m_aReader = new NonClosingReader(this.m_aReader);
            }
            return this;
        }

        @Nonnull
        public Builder setCustomizeCallback(@Nullable IJsonParserCustomizeCallback iJsonParserCustomizeCallback) {
            this.m_aCustomizeCallback = iJsonParserCustomizeCallback;
            return this;
        }

        @Nonnull
        public Builder setCustomExceptionCallback(@Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
            this.m_aCustomeExceptionCallback = iJsonParseExceptionCallback;
            return this;
        }

        public boolean hasSource() {
            return this.m_aReader != null;
        }

        public boolean isValidJson() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.parseJson(this.m_aReader, new DoNothingJsonParserHandler(), this.m_aCustomizeCallback, this.m_aCustomeExceptionCallback).isSuccess();
        }

        @Nullable
        public IJson read() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.readJson(this.m_aReader, this.m_aCustomizeCallback, this.m_aCustomeExceptionCallback);
        }

        @Nullable
        public IJsonArray readAsArray() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsArray();
        }

        @Nullable
        public IJsonObject readAsObject() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsObject();
        }

        @Nullable
        public IJsonValue readAsValue() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsValue();
        }
    }
}

