/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.json.parser.handler.IJsonParserHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StringAssemblyJsonParserHandler
implements IJsonParserHandler {
    private final StringBuilder m_aSB = new StringBuilder();

    @Override
    public void onWhitespace(@Nonnull @Nonempty String string) {
        this.m_aSB.append(string);
    }

    @Override
    public void onComment(@Nonnull String string) {
        this.m_aSB.append("/*").append(string).append("*/");
    }

    @Override
    public void onString(@Nonnull String string, @Nonnull String string2) {
        this.m_aSB.append(string);
    }

    @Override
    public void onNumber(@Nonnull String string, @Nonnull Number number) {
        this.m_aSB.append(string);
    }

    @Override
    public void onFalse() {
        this.m_aSB.append("false");
    }

    @Override
    public void onTrue() {
        this.m_aSB.append("true");
    }

    @Override
    public void onNull() {
        this.m_aSB.append("null");
    }

    @Override
    public void onArrayStart() {
        this.m_aSB.append('[');
    }

    @Override
    public void onArrayNextElement() {
        this.m_aSB.append(',');
    }

    @Override
    public void onArrayEnd() {
        this.m_aSB.append(']');
    }

    @Override
    public void onObjectStart() {
        this.m_aSB.append('{');
    }

    @Override
    public void onObjectName(@Nonnull String string, @Nonnull String string2) {
        this.m_aSB.append(string);
    }

    @Override
    public void onObjectColon() {
        this.m_aSB.append(':');
    }

    @Override
    public void onObjectNextElement() {
        this.m_aSB.append(',');
    }

    @Override
    public void onObjectEnd() {
        this.m_aSB.append('}');
    }

    @Nonnull
    public String getJsonString() {
        return this.m_aSB.toString();
    }
}

